; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_NC2GIF 
; 
;LAST CHANGED: ----------------------------------- 31-dec-99 
; 
; PURPOSE: 
;	This procedure converts one or a series of NetCDF image files 
; into gif format. Written for use with ENVI principle component procedures. 
; 
; CATEGORY: 
;	AXIS: image analysis 
; 
; CALLING SEQUENCE: 
;	AX_NC2GIF 
; 
; INPUTS: 
;	FILE - a NetCDF image file (*.nc) to be converted to gif (*.gif) 
; 
; KEYWORDS: none 
; 
; OUTPUTS: 
;  FILE.gif - image written as a GIF byte-scaled image file 
; 
; COMMON BLOCKS: 
;   @AXIS_COM - set of common blocks for AXIS 
;   @BSIF_COM - common block for netCDF 
; 
; SIDE EFFECTS: 
;	many ! 
; 
; RESTRICTIONS: 
;	caveat emptor 
; 
; PROCEDURE: 
; 
; RESTRICTIONS: 
;	ax_nc2gif assumes that filename has a sequence number is cols.6-8 
; This works with  X1A  (ddMMMxxx.nc) and ALS2NCDF (YMMDDxxx.nc) filenames 
; 
; MODIFICATION HISTORY: 
; (31-dec-99 aph) isolated from AXIS_C; standard documentation 
;- 
 
PRO ax_nc2gif 
@axis_com
@bsif_com
on_error,2 
 
WIDGET_CONTROL, Uprompt,  BAD_ID=BadID, SET_VALUE='pick first file of sequence' 
file1=PICKFILE2(/Read, FILTER='*.nc', /LPATH, DEFPATH=defpath) 
if strlen(file1) GT 0 THEN BEGIN 
 WIDGET_CONTROL, Uprompt, BAD_ID=BadID, SET_VALUE='pick last file of sequence' 
 file2=PICKFILE2(/Read, FILTER='*.nc', /LPATH, DEFPATH=defpath) 
 if strlen(file2) GT 0 THEN BEGIN 
; assumes all NSLS file names are 12 char. and columns 6-8 are a sequential file number 
; NSLS X1A  file name convention is DDMMM###.nc 
    spos=strpos(file1,'.') 
	fileroot=strmid(file1, 0, spos-3) 
	fileshort=strmid(file1,spos-8, 5) 
	file=strmid(file1,spos-8, 8)    	  ; in case only 1 file specified ! 
	first = fix(strmid(file1,spos-3, 3)) 
	last  = fix(strmid(file2,spos-3, 3)) 
; allow any extension by picking up ext from pickfile choice (aph 14-feb-98) 
	ext = strmid(file1,spos+1,3)    ; take extension 
	tmp = read_bnl(file1) 
	all = fltarr(n_elements(tmp.x), n_elements(tmp.y), (last-first+1)) 
	all(*,*,0) = tmp.d 
	maxval = fltarr(last-first+1) 
	energ = fltarr(last-first+1) 
	maxval(0) = max(tmp.d) 
	if sd.wavelength EQ 0. then sd.wavelength = 12398. 
	energ(0) = 12398./sd.wavelength 
	for i = first+1, last do begin 
  		num = strcompress(string(1000 + i)) 
  		num = strmid(num,2,4) 
  		file_in = fileroot + num + '.' + ext 
  		file = fileshort+num 
  		tmp = read_bnl(file_in) 
      	all(*,*,i-first) = tmp.d 
      	maxval(i-first) = max(tmp.d) 
      	if sd.wavelength EQ 0. then sd.wavelength = 12398. 
		energ(i-first) = 12398./sd.wavelength 
    endfor 
    maxval_all = max(maxval) 
    for i = 0,last-first DO BEGIN 
    	num = strcompress(string(1000+first+i)) 
  		num = strmid(num,2,4) 
  		file_out = fileroot + num + '.gif' 
    	topval = 255*maxval(i)/maxval_all 
  		Write_GIF, file_out, bytscl(all(*,*,i), top=topval) 
;      	print, file,' E=',energ(i),' max =',fix(maxval(i)), $ 
;      		    '  scaled to', fix(topval) 
  		WIDGET_CONTROL, Uprompt, BAD_ID=BadID, SET_VALUE= $ 
  		 'NSLS_to_GIF '+file+'        E='+strcompress(string(energ(i))) $ 
  		 + '      gifmax'+ strcompress(string(fix(topval))) 
	endfor 
endif 
endif 
end 
