; Copyright (c) 2013 -  A.P. Hitchcock, Florian Meirer, Dieter Ingerle  All rights reserved

;+
;NAME:
;		AX_READ_TXRM_STXM
;
;LAST CHANGED: ----------------------------------- 	29-Apr-2013
;
; PURPOSE:
;	This function uses an external call to a Java routine to read a sequence of
;  Xradia *.txrm images, stored in Microsoft Structured Storage (COM) format
;
; CATEGORY:
;	Image  read in. Stand alone, and called in aXis2000 at
;
; CALLING SEQUENCE:
;	Result = AX_READ_TXRM(, [FILE=FILE, NOF=NOF, SILENT=SILENT])
;
; INPUTS: none
;
; KEYWORDS:
;	FILE	filename (with path)
;   NOF	    if set, do not specify *.txrm as the extension
;   SILENT	if set, do not provide printed comments
;
; OUTPUTS:
;	stack is written to disk
;
; COMMON BLOCKS:
;	AXIS_COM		standard set of common blocks
; 	BSIF_COM		standard stack parameters (from nsls1)
;	VOLUME_DATA 	image_stack
;
; SIDE EFFECTS: none
;
; RESTRICTIONS:
;	Will only work if appropriate IDL-Java software is included in the appropriate location
;
; PROCEDURE:
; The Java class txmreader creates a java list of java objects,
; one for each image stored in the txrm file
;
; EXAMPLE:
;
; MODIFICATION HISTORY:
; (28-Apr-13 aph) first version; AXIS standard header added
;-


FUNCTION ax_read_txrm_stack, nof=nof, silent = silent
@axis_com
@stack_process_com
COMMON volume_data, image_stack
@bsif_com
on_error,2

; ---- get filenames from a stack list file
listfile = DIALOG_PICKFILE(/Read, FILTER='*.txrm',/multiple, $
    title = 'Select TXRM stack files (left click first, navigate to last, and hold SHIFT key, then left click', PATH=defpath)
if listfile(0) EQ '' then return, '0'  ;  handle a CANCEL

; for i = 0, n_elements(listfile)-1 do print, listfile(i)

; ---------- sort : NB assumes files names will ascii sort in order they were recorded
;t_ord=sort(listfile)
;tmp = listfile
;for i = 0, n_elements(listfile)-1 do begin
;	tmp(i) = listfile(t_ord(i))
;endfor
;listfile = tmp

; ------ set Java library location --------
; setenv,'IDLJAVAB_LIB_LOCATION=C:\Program Files\Java\jre7\lib'

; -------- check that sorting worked -------
;openw, lun, 'listfile.txt', /get_lun
;for i = 0, n_elements(listfile)-1 do begin
; 	print, listfile(i)
;	printf,lun, listfile(i)
;endfor
;close, lun  & free_lun, lun

 listfile=reverse(listfile)		; KLUGE - if take in order DIALOG_PICKFILE gives [last, then 0 - (n-2) ] OR ordered
;								  the first file read fails "exception thrown; line 83 in ax_read_txrm

; ---- generate short file name
t=ax_name(listfile(0))
DefPath = t(0)
fileshort = t(1)
; trincate at first '_'
fileshort = strmid(fileshort,0,strpos(fileshort, '_'))

print, 'short name is ', fileshort

; ----- read in first image and define size of image_stack

tmp = ax_read_txrm(file=listfile(0))
nx = n_elements(tmp.x)
ny = n_elements(tmp.y)
n_img = n_elements(listfile)
image_stack = fltarr(nx,ny,n_img-2)		; KLUGE to get around error in reading last 2 *.txrm files
image_stack(*,*,0)=tmp.d

; -- prepare arrays for filename_ev_ms list and energy (ev)
filename_list = strarr(1)
filename_list(0) = string(FORMAT="(A,'_',i3)",fileshort,0)
filename_ev_list = strarr(1)
filename_ev_list(0)=string(FORMAT="(A,'_',i3,' ',F8.3,'  ',F6.2)",fileshort,n_img-2, tmp.e,xrf_dwell)
ev=fltarr(1)
ev(0)=tmp.e

; ----------  read in all the images ----------
for i = 1, n_img - 3  do begin
	filename_list = [filename_list,' ']			; extend the arrays by 1
	filename_ev_list = [filename_ev_list,' ']
	ev=[ev,1.]
	nextfile = listfile(i)
	filenum = n_img-2-i
;	print, 'next file is ', nextfile
	tmp = ax_read_txrm(file=nextfile, /silent)
	filename_list(i) = string(FORMAT="(A,'_',i3)",fileshort,filenum)  ; KLUGE to get image numbers in order
	filename_ev_list(i)=string(FORMAT="(A,'_',i3,' ',F8.3,'  ',F6.2)",fileshort,filenum, tmp.e,xrf_dwell)
	ev(i)=tmp.e
	if not keyword_set(silent) then begin
		text = string(format="(i4,'   ', f8.3)", i, tmp.e)
		axis_log, text
	endif
	image_stack(*,*,i)=tmp.d
endfor

; ---- reverse order of images ----
;image_stack = reverse(image_stack, 2, /overwrite)
;ev = reverse(ev)
;filename_list = reverse(filename_list)
;filename_ev_list = reverse(filename_ev_list)
filename_ev_msec_list = filename_ev_list		; this is what is used by stack_wb - transferred in stack_process

; help, filename_ev_msec_list

t = ax_name(listfile(i-1))
axis_log, string(FORMAT="(i4, ' of ', i4, ' files read. Last file read was ', A)", i, n_img, t(1))
print, 'subsequent files cannot be read due to exception thrown error'
print, 'in  oJTxmImgFactory Java routine in ax_read_txrm.ppro'

; define parameters needed for stack write out
svec = size(image_stack)
n_cols = nx  & n_rows = ny
x_start = tmp.x(0)
x_stop = tmp.x(nx-1)
y_start = tmp.y(0)
y_stop = tmp.y(ny-1)
xstep = (x_stop - x_start)/n_cols
ystep = (y_stop - y_start)/n_rows


;----- write stack as aXis format binary (*.ncb)
outfile = pickfile2(file=fileshort, /WRITE, FILTER='*.ncb', /LPATH, DEFPATH=defpath)
stack_wb, outfile

; ----- return the name of the stack for subsequent processing
return, outfile

END