; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	BLBL_UPD
;
;LAST CHANGED: ----------------------------------- 16-Feb-2010
;
;PURPOSE:
; updates buffer labels in aXis2000
;
;CATEGORY:
;	AXIS:  utility (captive)
;
;CALLING SEQUENCE:
;	BLBL_UPD
;
;CALLED FROM AXIS:
;	whenever execute PlotBuf to display a new Buffer; clear; etc
;
;ROUTINES
;	BLBL_UPD  - update the labels (which displayed for multi, lable contents)
;
 ;INPUTS: none (via axis_com)
;
;KEYWORDS: none
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (   MAR-98 APH) split from axis_c to shrink file
; (14-jun-98 aph) add axis_com
; (24-jun-99 aph) consistent color for image/spectra ; ADD zstack_color_common
; (26-jul-99 aph) if curBuf=0, only update labels
; (26-sep-99 aph) separated from THUMBS.PRO to have file name = run name
;                adapted to 9 separate windows
; (31-jan-00 aph) AXIS standard documentation; re-ordered to avoid loss of utility routines
; (11-mar-00 aph) remove comment on @axis_com line
; (16-apr-00 aph) handle 3d images which have 3-channel (3-d) data structure
; (19-dec-00 cgz) substituted ax_white_color_index with ax_plot_axes_color_index
;			substituted ax_black_color_index with ax_plot_bkgd_color_index
; (16-Feb-10 aph) separated from parent Thumllbls.pro file to follow IDL conventions
;-


PRO BLbl_upd
; update Buffer labels
@axis_com
  FOR i = 0, 9 DO BEGIN
  	WIDGET_CONTROL, ButIDs(i), SET_VALUE=STRCOMPRESS(STRING(i)) + '  ' + Label(i)
    BufStat(i) = 0
  ENDFOR
  BufStat(CurBuf) = 1
  WIDGET_CONTROL, BufButs, SET_VALUE = BufStat
  GraphFrozen = 0 ; ensure cursor is active on MainImg
  END
