; Copyright (c) 1998-2001 A.P. Hitchcock  All rights reserved
;+
;NAME: DISTANCE
;
;LAST CHANGED: ----------------------------------- 08-may-01
;
; PURPOSE:
;	This function computes the distance between two points in Cartesian space
;
; CATEGORY:
;	math utility
;
; CALLING SEQUENCE:
;	Result = DISTANCE(pt1, pt2)
;
; INPUTS:
;	PT1 	[x1,y1]
;	PT2		[x2,y2]
;
; KEYWORDS: none
;
; OUTPUTS: returns SQRT(|x1-x2|^2 + |y1-y2|^2)
;
; COMMON BLOCKS: none
;

; MODIFICATION HISTORY:
; (08-may-01 aph) first wrote; AXIS standard header added
;-

function distance, pt1, pt2
on_error, 2

d = sqrt((pt1(0)-pt2(0))*(pt1(0)-pt2(0)) + (pt1(1)-pt2(1))*(pt1(1)-pt2(1)))

return, d
end

