; Copyright (c) 1998-2011 A.P. Hitchcock  All rights reserved
;+
;NAME: gen_AA_String
;
;
;LAST CHANGED: ----------------------------------- 	03-Feb-11
;
; PURPOSE:
;	This function genertes and saves to a file a text string
; derived from  a file containing code letters and numbers
; to be used in conjunction with XSpecSIm to simulate protein spectra
;
; CATEGORY:
;	utility (not in aXis2000)
;
; CALLING SEQUENCE:
;	Result = gen_AA_String(file = file)
;
; INPUTS:
; This section is for POSITIONAL INPUTS only (not keywords)
;	All input parameters are passed as keywords.
;
; KEYWORDS:
;	FILE	filename (if not included user is allowed to browse)
;
; OUTPUTS:
;	user is prompted for name of a text file to be written
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; SIDE EFFECTS: none
;
; MODIFICATION HISTORY:
; (02-Nov-07 aph) first version
; (03-Nov-10 aph) corrected @axis-com  to @axis_com
; (03-Feb-11 aph) corrected copyright date
;-

Function gen_AA_String, file=file

@axis_com
on_error,2

IF NOT keyword_set(file) then begin
	fltr='*.txt'
	if keyword_set(nof) then fltr='*'
	file = pickfile2(/READ, FILTER=fltr, /LPATH, DEFPATH=defpath)
ENDIF
s = ''
if file EQ '' THEN RETURN, s  ; bail-out if no filename
check = findfile(file)		 ; bail-out if non-existent file
if strlen(check(0)) EQ 0 then begin
	axis_log, 'Cannot find ' + file
	return, s
endif
openr, iunit, file, /get_lun
txt = ''
num=0
line = ''
np = 0
WHILE NOT EOF(iunit) DO BEGIN
 	readf, iunit, line
;		 	print,line
	code = strmid(line,0,1)
	line = strmid(line,1)
	num = fix(line)
;	print, 'code = ', code, '   number = ', num
 	for i = 0, num-1 do  txt = [txt+code]
 	np = np + 1
ENDWHILE
;print, txt
close, iunit
free_lun, iunit


file2 = pickfile2(/WRITE, FILTER=fltr, /LPATH, DEFPATH=defpath)
openw, iunit, file2, /get_lun
printf, iunit, txt
close, iunit
free_lun, iunit

t = ax_name(file2)

axis_log, 'AA composition written to ' + t(1)
return, file2
end

