; Copyright (c) 1998-2009 A.P. Hitchcock  All rights reserved
;+
;NAME: NCB_TO_MPG
;
; LAST CHANGED: -------------------------------- 30-Jul-09
;
; PURPOSE:
;	This procedure converts a ncb stack into a MPEG movie
;
; CATEGORY:
;	stack processing
;
; CALLING SEQUENCE:
;	NCB_TO_MPG, FILE
;
; INPUTS:
; 	FILE	name of the output file
;
; KEYWORDS: none
;
; OUTPUTS:
;	*.mpg file
;
; COMMON BLOCKS:
; AXIS_COM	standard set of common blocks
; stack_process_com
; BSIF_COM
; volume_data
;
; SIDE EFFECTS:
;
; RESTRICTIONS: none
;
; MODIFICATION HISTORY:
; (14-Jun-06 gaj) first version
; (01-Aug-06 gaj) finished first working version
; (02-Aug-06 gaj) fixed the scaling to avoid colors in the movies
; (30-jul-09 aph) changed analcom to stack_process_com (update to stack_process)
;
;-

; ***************************************************************************
;            NOTE re further development of this widget
; As of IDL 5 (?) writing MPEG files requires an addition license from IDL
; IDL suggests to replace MPEG with MJPEG2000 format movies
; consider adapting the example MJPEG2000 player and writer procedures supplied
;
; see the entry, Overview of Motion JPEG2000  in the IDL Help file for further info
;
; ***************************************************************************


PRO ncb_to_mpg, file
@axis_com		; include COMMON from file
@stack_process_com
@bsif_com
COMMON volume_data, image_stack

on_error,2
if strlen(file) EQ 0 then begin
	file = pickfile2(/WRITE, FILTER='*.*', /LPATH, DEFPATH=defpath)
endif

if strlen(file) GT 0 then begin

	t = ax_name(file)
	file_name = t(1) + '.' + t(2)
	file_path = t(0)
	stack_rb, (file_path + file_name)		;read stack in ncb format
	file_name =  t(1) + '.mpg'

	; Adjust contrast
	imstk = image_stack
    imstk(*) = (image_stack(*)-min(image_stack(*)))/(max(image_stack(*))-min(image_stack(*)))*223+16 ; 223+16 to avoid colors in movie

	dims = size(imstk)

	; start movie tool
	xinteranimate, set=[dims(1),dims(2),dims(3)], /showload
	for i=0,dims(3)-1 do xinteranimate, frame = i, image = imstk[*,*,i]
	xinteranimate, 50, /keep_pixmaps ; 50 = relative framrate

	axis_log, 'Creating MPEG movie '

ENDIF
END
