; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AX_SWITCH 
; 
;LAST CHANGED: ----------------------------------- 01-jan-00 
; 
;PURPOSE: 
;	This procedure switches the active buffer using the thumbnails 
; or the buffer labels. It also processes flags for other uses for the 
; thumbnail switches, such as copying buffers. 
; 
;CATEGORY: 
;	AXIS:  utility 
; 
;CALLING SEQUENCE: 
; for procedures: 
;	AX_SWITCH, BufNum 
; 
;CALLED FROM AXIS: 
;	->on mouse click on a thumbnail 
 
;INPUTS: 
;	BUFNUM - number of buffer selected by left mouse click. 
;	other control parameters transferred via common 
; 
;KEYWORDS: none 
; 
;OUTPUTS: none 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
; PROCEDURE: 
; switches among buffers & processes flags 
; meaning of variables 
;	NewBuf - (axis_common) new buffer number 
; 	CurBuf - (axis_common) current buffer number 
;	select_flag - identifies that thumbnail 'button push' is being 
;                 used to select buffer for a function other than plotting 
; NB - this code always resets select_flag regardless of action 
;	copy_flag = identifies action as a copy from CurBuf to NewBuf 
; 
;MODIFICATION HISTORY: 
; (30-oct-99 aph) first written to use new thumbnails as switches 
; (01-jan-00 aph) AXIS standard documentation 
;- 
PRO AX_SWITCH, BufNum 
@axis_com
on_error,2 
 
if select_flag EQ 1 then begin 
	NewBuf = BufNum 
	if copy_flag EQ 1 then ax_copy 
endif else begin 
	CurBuf = BufNum 
	PlotBuf, CurBuf 
endelse 
select_flag = 0 
END 
