; Copyright (c) 1995, ALS SpectroMicroscopy Facility, jdd 
; 
;FILE:  structure.pro 
;+ 
;2D Sructure procedures for Microscopy images 
;Current Structure format: 
;   s = {D:data, X:xarr, Y:yarr, XL:xlabel, YL:ylabel, DL:title} 
; 
;  fct STAG, s, tag(s)	-- checks existence of structure field(s) 
;
; (11-nov-00 cgz) migrated from STRUCTURE.PRO
;- 
 
 
function STAG, s, tags 
;====================== 
; check existence of structure field (or tag); 
; returns T/F (0/1) byte or byte array 
on_error,2 
ss=size(s) 
if ss(0)*ss(2) ne 8 then message, 'input not a structure' 
 
fields=strlowcase( tag_names(s) ) 
fstr='' 
for i=0, n_tags(s)-1 do fstr=fstr+fields(i)+';' 
;print, fstr 
 
tags=strlowcase(tags) 
nt=n_elements(tags) 
exist=bytarr(nt) 
for i=0, nt-1 do exist(i)=strpos( fstr, tags(i) ) gt -1 
;print, exist 
;exist= fix( (exist+.1)/abs(exist+.1) )>0 
if nt eq 1 then return, exist(0) $ 
else return, exist 
end 
 
