; Copyright (c)1998-2010 Jacob Stewart-Ornstein & A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AVERAGEVAL.PRO
;
;LAST CHANGED: -----------------------------------  19-Jul-10
;
; PURPOSE:
;	This function projects from existing spectral data the value at a requested X-point
;
; CATEGORY:
;	spectra processing; part of XSpecSim package
;
; CALLING SEQUENCE:
;	Result = AverageVal(ARR=ARR, VAL=VAL)
;
; INPUTS: none
;
; KEYWORDS:
;	ARR		2d array of energy and spectral data
;	VAL 	energy value to generate interpolated data
;
; OUTPUTS: none
;
; COMMON BLOCKS: none
;
; MODIFICATION HISTORY:
; (21-Jul-06 jso) first version
; (19-jul-10 aph) AXIS standard header added
;-

Function AverageVal, arr=arr, val=val
	i=0
	ans =0
	while i NE length(arr)-1 do begin
		if val le arr(0,i+1) and val Ge arr(0,i) then begin
			slope = (arr[1,i+1]-arr[1,i])/(arr[0,i+1] - arr[0,i])
			ans = arr(1,i) + slope * (val - arr[0,i])
			return, ans
		endif
		i = i+1
	endwhile
end