FUNCTION tif_load, NOF=nof, error=err, BMP=bmp, GIF=gif, _extra=e
;+
; FUNCTION tif_load, NOF=nof, error=err, BMP=bmp, GIF=gif, _extra=e
; ------------------------------ last changed: 14-jun-98
;
;* tif, *.bmp, *.gif file read-in 
;-
; ---------------------- REVISION HISTORY ---------------
; (aph 20-feb-98) first developed
; (aph 14-jun-98) axis_com

@axis_com
on_error,2

fltr='*.tif'
if keyword_set(bmp) then fltr = '*.bmp'
if keyword_set(gif) then fltr = '*.gif'
if keyword_set(nof) then fltr='*'
file = pickfile2(/READ, FILTER=fltr, /LPATH, DEFPATH=defpath)
if strlen(file) GT 0 THEN BEGIN  ; bail-out if no filename
if keyword_set(gif) then begin
      read_gif, file, tmp, R, G, B
;     tmp = reverse(tmp,1)
	  main = 360*gr_scale
  	  tmp = congrid(tmp, main, main)
  	  if n_elements(R) NE 0 then begin
      	TVLCT, R, G, B
      	TVLCT, UserR, UserG, UserB, /get        ; sets default color table !
      endif
  endif
  if keyword_set(bmp) then begin
      tmp = read_bmp(file, R, G, B)
;     tmp = reverse(tmp,1)
	  main = 360*gr_scale
  	  tmp = congrid(tmp, main, main)
  	  if n_elements(R) NE 0 then begin
      	TVLCT, R, G, B
      	TVLCT, UserR, UserG, UserB, /get        ; sets default color table !
      endif
  endif else begin
  	tmp = tiff_read(file)
  	tmp = reverse(tmp,2)        ;files written by AXIS are up/down reversed
  endelse
  ts = size(tmp)
  nx = ts(1) &  ny = ts(2)
  x = fltarr(nx)
  y = fltarr(ny)
  s = {t:'3d', x:x, y:y, d:tmp, xl:'', yl:'', dl: file}
  print, 'image read from: ', file
endif else begin 	; go here if user pushes 'cancel'
;   	print, ' file not read'
   	s=0
endelse
return, s
end