; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	XAS_XRF_EXTRACT
;
;LAST CHANGED: ----------------------------------- 21-apr-10
;
;PURPOSE:
;	This function extracts absorption stacks from a 4-d array (*.ssb)
; written by XAS_XRF_STACK and writes them as regular 3D stacks (*.ncb)
;
;CATEGORY:
;	STAND ALONE: utility
;
;CALLING SEQUENCE:
;	Result = XAS_XRF_EXTRACT( [,ch_low=ch_low, ch_hi=ch_hi. file=file, silent=silent])
;
;CALLED FROM AXIS:
;	Read->Images->AXIS
;
;INPUTS:
;	TMP - AXIS 4d array (x,y,E-XRF,E-XAS)
;
;KEYWORDS:
;	CH_LOW	lower limit of channels / energies to integrate
;	CH_HI	upper limit of channels / energies to integrate
;	FILE - filename to read
;	SILENT  flag to control entry to axis log
;
;COMMON BLOCKS:
; AXIS_COM	standard set of common blocks
; STACK_PROCESS_COM
; BSIF_COM
; volume_data, image_stack
; volume_data2, xas_xrf_stack
;
;;MODIFICATION HISTORY:
; (21-Apr-10 aph) first written

function xas_xrf_extract, file=file, ch_low=ch_low, ch_hi=ch_hi, silent=silent, $
             verbose=verbose, group=group, extra = extra
@axis_com
@stack_process_com
COMMON volume_data, image_stack
COMMON volume_data2, xas_xrf_stack
@bsif_com
on_error,2

;  ---------- read  *.ssb data if needed
if n_elements(xas_xrf_stack) EQ 0 then  begin
	ev = stack2_rb()
;	help, xas_xrf_stack
endif

; --------- ask user for lower and upper channel limits if not given
; to write

; -------- define size of 3d stack to extract
im_size = size(xas_xrf_stack)
nx = im_size(1)
ny = im_size(2)
npts = im_size(3)
n_stacks = im_size(4)
image_stack = fltarr(nx, ny, n_stacks)

; ------ extract from  xas_xrf_stack
for i = ch_low, ch_hi do begin
	image_stack = image_stack + xas_xrf_stack(*,*,i,*)
endfor

; ------ write as binary stack
file = pickfile2(/write, TITLE = 'name of stack file', FILTER='*.ncb', /LPATH, DEFPATH=defpath)
stack_wb, file

s=1
return, s

end
