; Copyright (c) 1998-2011 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_IMG_DEL
;
;LAST CHANGED: ----------------------------------- 03-Feb-11
;
; PURPOSE:
;	This procedure replaces all pixels in a user-selected region
; by user-selected value (default is the meanof the whole image)
; If image is larger than or less than 1/2 themain display window size
; the image is resized
;
; CATEGORY:
;	AXIS: image analysis
;
; CALLING SEQUENCE:
;	AX_IMG_DEL
;
;CALLED FROM AXIS:
;	->Images->Delete region

; INPUTS:
;	All input parameters are passed as keywords or through AXIS_COM
;
; KEYWORDS: none
;
; OUTPUTS:
;	Modified image placed in buffer 0.
;
; COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
; PROCEDURE:
;	Uses DefROI widget for felxible region of interest definition
;  If image is larger than the MainWid size (360*gr_scale) then a temporary image is generated
;   f rediced size using congrid  NOT rebin in order to handle non integer zooms
;  For congrid, the cubic=-0.5 option is used for greater accuarcy (see IDL HELP for congrid)
;
; RESTRICTIONS:
;	only executable from AXIS
;
; MODIFICATION HISTORY:
; (31-dec-99 aph) first written
; (03-Feb-11 aph) reduce size of large images prior to delete operation & re-scale after deletion
;         content was there but incorrect !
;-

PRO ax_img_del

@axis_com
on_error,2

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
IF tmp.t EQ '2d' THEN BEGIN
	img_zoom = 1
	ncol = n_elements(tmp.x) & nrow = n_elements(tmp.y)
	img_size = max([ncol, nrow])
	if img_size GT 360*gr_scale then img_zoom =  floor(img_size / 360*gr_scale) + 1  ;for images larger than 360*gr_scale
	if img_size LT 160*gr_scale then begin
	    img_zoom =  floor(360*gr_scale / img_size) + 1
	    img_zoom = 1./img_zoom
	endif
	if img_zoom EQ 0 then img_zoom = 1

	SetGraf, 'MainImg'
	erase
	loadct,ColTbl,/silent
; ----
	if img_zoom NE 1 then begin
		print, ' max image dimension = ', strtrim(string(img_size),2)
		if img_zoom GT 1 then print, ' Zoom factor = ', img_zoom $
		  else print, ' Zoom factor = 1/', strtrim(string(fix(1./img_zoom)),2)
		t_img = congrid(tmp.d, fix(ncol/img_zoom), fix(nrow/img_zoom), cubic = -0.5)
		tvscl, t_img
	 	roi = cw_defroi(MainWid, image_size = [ncol/img_zoom, nrow/img_zoom])
;		print,'Zoom = ', img_zoom, '.   ROI limits: ',min(roi),max(roi)
		svec = size(roi)
		IF (svec(0) NE 0) THEN BEGIN	; proceed only if roi is real region
			t = moment(tmp.d,/nan)
			replace = get_num(Prompt = 'replace with ',val = t(0) , group = axis_ID)
			t_img(roi) = replace
		endif
		tmp.d = congrid(t_img, ncol, nrow, cubic = -0.5)
		if img_zoom GT 1 then text = string(img_zoom, format='(I2)') $
		   else text = '1/' + string(1./img_zoom, format='(I2)')
		axis_log, 'image rescaled by  ' + text  + ' before manual deletion'
		text = 'Dr '
	endif else begin
		tvscl, tmp.d
	 	roi = cw_defroi(MainWid, image_size = [ncol, nrow])
		svec = size(roi)
		IF (svec(0) NE 0) THEN BEGIN	; proceed only if roi is real region
			t = moment(tmp.d,/nan)
			replace = get_num(Prompt = 'replace with ',val = t(0) , group = axis_ID)
			tmp.d(roi) = replace
		endif
		text = 'D '
		axis_log, 'manual image deletion'
	endelse
	ax_color
	CurBuf = 0
	tmp.dl =  text + tmp.dl
	HANDLE_VALUE, Data(CurBuf), tmp, /set
	PlotBuf, CurBuf
	Label(CurBuf) = tmp.dl
ENDIF ELSE WIDGET_CONTROL, Uprompt, Set_Value = 'Image delete region: only for images'
END
