; Copyright (c) 1998-2005 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_FILE_LOAD
;
;LAST CHANGED: ----------------------------------- 16-jun-05
;
;PURPOSE:
;	This set of procedures is a widget to select columns of a multi-column ascii file
; to read in as a (x,y) 1-d data set. The widget uses SPC_LOAD to execute the read-in
;
;CATEGORY:
;  AXIS: utility
;
; AX_SPC_LOAD_EVENT ROUTINES:
;
; TEXT_SPC_LOAD_FNAME		modify filename; when changed, execute BUT_SPC_LOAD_FNAME_BROWSE to get parameters
; BUT_SPC_LOAD_FNAME_BROWSE browse for new filename; if found, load new parameters
; BUT_SPC_LOAD_DISPLAY_HDR  show all file
; BUT_SPC_LOAD_OK			proceed with loading multi-column file into AXIS
; BUT_SPC_LOAD_CANCEL		abort read in
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks (inludes mcf_com)
;
;MODIFICATION HISTORY:
; (14-feb-03 aph) first version
; (26-oct-04 aph) save last file name; merge mcf_com with axis_com
; (16-jun-05 aph) correct indexing for rows to skip
;-
;
;-----------------------------------------------------------------
pro TEXT_SPC_LOAD_FNAME, Event
on_error,2
@axis_com

; get the changed name
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_FNAME')
WIDGET_CONTROL,id, Sensitive=1, Get_value = fname

; -- check if the filename exists - if not assume this is just a trap out of
; -- the user starting to type a changed name or a mistake
t = findfile(fname(0), count=t_count)
;if t_count EQ 0 then return
; print, 'New filename is ', fname(0)
mcf_lastfile = fname(0)
; update details
BUT_SPC_LOAD_FNAME_BROWSE, Event, file = fname(0)
end

;-----------------------------------------------------------------
pro TEXT_SPC_LOAD_EXT, Event
on_error,2
@axis_com

; get the changed name
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_EXT')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
mcf_ext = tmp(0)
; print, 'New extension is ', mcf_ext

end

;-----------------------------------------------------------------
pro BUT_SPC_LOAD_FNAME_BROWSE, Event, file=file
on_error,2
@axis_com

if not keyword_set(file) then begin
	if strlen(mcf_ext) EQ 0 then mcf_ext = '*.*'
	fname = pickfile2(Title='Select file', Filter = mcf_ext)
endif else fname = file
if strlen(fname) GT 0 then begin
	mcf_lastfile = fname(0)	; ensure the filename is saved for future use
;	print, 'New filename is ', mcf_lastfile
; update name in the text box
	id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_FNAME')
	WIDGET_CONTROL,id, Set_value = fname
; read file and update contents of header box
	openr, iunit, fname, /get_lun
	text = ''
	readf, iunit, text
	id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_HEADER')
	WIDGET_CONTROL,id, Set_value = text
	for i = 1, 6 do begin
		readf, iunit, text
		WIDGET_CONTROL,id, Set_value = text, /append
	endfor
	mcf_lastrow = 6
	close, iunit & free_lun, iunit
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_LASTROW')
WIDGET_CONTROL,id, Set_value = strtrim(string(mcf_lastrow),2)
endif
end

;-----------------------------------------------------------------

pro BUT_SPC_LOAD_MORE, Event, group=wGroup
on_error,2
@axis_com
; get the header filename
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_FNAME')
WIDGET_CONTROL,id, Get_value = fname

; read file and update contents of header box
openr, iunit, fname, /get_lun
text = ''
readf, iunit, text
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_HEADER')
WIDGET_CONTROL,id, Set_value = text
for i = 1, mcf_lastrow + 6 do begin
	readf, iunit, text
	WIDGET_CONTROL,id, Set_value = text, /append
endfor
close, iunit & free_lun, iunit
mcf_lastrow = mcf_lastrow + 6
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_LASTROW')
WIDGET_CONTROL,id, Set_value = strtrim(string(mcf_lastrow),2)
end

;-----------------------------------------------------------------
pro TEXT_SPC_LOAD_X_AXIS, Event
on_error,2
@axis_com

; get the changed region
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_X_AXIS')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
mcf_Xcol = fix(tmp)
; print, 'mcf_Xcol set to ', mcf_Xcol
end

;-----------------------------------------------------------------
pro TEXT_SPC_LOAD_Y_AXIS, Event
on_error,2
@axis_com

; get the changed region
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_Y_AXIS')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
mcf_Ycol = fix(tmp)
; print, 'mcf_Ycol set to ', mcf_Ycol
end

;-----------------------------------------------------------------
pro TEXT_SPC_LOAD_ROWS, Event
on_error,2
@axis_com

; get the changed region
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_ROWS')
WIDGET_CONTROL,id, Sensitive=1, Get_value = tmp
mcf_rows = fix(tmp)
; print, 'mcf_rows set to ', mcf_rows
end

;-----------------------------------------------------------------
pro BUT_SPC_LOAD_CANCEL, Event
on_error,2
@axis_com

WIDGET_CONTROL, Event.Top, /DESTROY
mcf= 0
end

;-----------------------------------------------------------------
pro BUT_SPC_LOAD_OK, Event
on_error,2
@axis_com

; get the  name
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_FNAME')
WIDGET_CONTROL,id, Sensitive=1, Get_value = fname
widget_control, /hourglass

;------------- read in selected columns using SPC_LOAD --------------
print, 'Reading in spectrum from ', fname
print, 'X-axis = column ', strtrim(string(mcf_Xcol),2),  $
     '  Y-axis = column ', strtrim(string(mcf_Ycol),2)

mcf = spc_load(file=fname(0), typ = 'mc', xcol=mcf_Xcol(0), ycol=mcf_Ycol(0),skip= mcf_rows(0))
mcf_lastfile = fname(0)
WIDGET_CONTROL, Event.Top, /DESTROY
return
end


;-----------------------------------------------------------------
pro BUT_SPC_LOAD_ALL, Event
on_error,2
@axis_com

; get the  name
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SPC_LOAD_FNAME')
WIDGET_CONTROL,id, Sensitive=1, Get_value = fname
widget_control, /hourglass

;------------- read ALL columns using SPC_LOAD --------------
nspec = spc_load(file=fname(0),  /multi)  ;typ = 'mc', skip=mcf_rows(0))	; find number of columns
if nspec(0) EQ 1 then begin
	tmp = spc_load(file=fname(0), xcol = 1, ycol =2, typ = 'mc', skip=mcf_rows(0))
	HANDLE_value, Data(CurBuf),tmp,/set
	Plotbuf,CurBuf
endif else begin
	CurBuf = CurBuf - 1
	for i = 2, nspec(0)+1 do begin
		CurBuf = CurBuf + 1
		tmp=spc_load(file=fname(0), xcol = 1, ycol = i, typ = 'mc', skip=mcf_rows(0))
	  	HANDLE_value, Data(CurBuf),tmp,/set
	   	Plotbuf,CurBuf
	endfor
endelse
mcf = 0
WIDGET_CONTROL, Event.Top, /DESTROY
return
end

;
; **************************************************************
;
pro BASE_SPC_LOAD_event, Event
@axis_com

  wWidget =  Event.top

;  print, tag_names(event, /structure_name)

  case Event.id of

    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SPC_LOAD_FNAME'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_CH' )then $
        TEXT_SPC_LOAD_FNAME, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SPC_LOAD_EXT'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_CH' )then $
        TEXT_SPC_LOAD_EXT, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SPC_LOAD_FNAME_BROWSE'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SPC_LOAD_FNAME_BROWSE, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SPC_LOAD_MORE'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SPC_LOAD_MORE, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SPC_LOAD_X_AXIS'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_CH' )then $
        TEXT_SPC_LOAD_X_AXIS, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SPC_LOAD_Y_AXIS'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_CH' )then $
        TEXT_SPC_LOAD_Y_AXIS, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SPC_LOAD_ROWS'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_CH' )then $
        TEXT_SPC_LOAD_ROWS, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SPC_LOAD_ALL'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SPC_LOAD_ALL, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SPC_LOAD_OK'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SPC_LOAD_OK, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SPC_LOAD_CANCEL'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SPC_LOAD_CANCEL, Event
    end
    else:    print, Event.id, ' not found'
  endcase

end
;-----------------------------------------------------------------

pro BASE_SPC_LOAD, file=file, ext=ext, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com

;  Resolve_Routine, 'ax_file_load_eventcb'     ; Load event callback routines
t = size(wGroup)
IF t(1) EQ 0 THEN modal_val=0 else modal_val=1
IF t(1) EQ 0 THEN read_all_sens = 0 else read_all_sens = 1

; set up first entries to widget
	mcf_lastrow = 0
	if  n_elements(mcf_Xcol) EQ 0 then mcf_Xcol = 1
	if  n_elements(mcf_Ycol) EQ 0 then mcf_Ycol = 2
	if  n_elements(mcf_rows) EQ 0 then mcf_rows = 0
	if keyword_set(ext) then mcf_ext = ext else mcf_ext = '*.*'

  BASE_SPC_LOAD = Widget_Base( GROUP_LEADER=wGroup,  $
      UNAME='BASE_SPC_LOAD',  modal = modal_val $
      ,TITLE='Read spectral & other 1-d files' ,SPACE=3 ,XPAD=3, YPAD=3)

  TEXT_SPC_LOAD_FNAME = Widget_Text(BASE_SPC_LOAD, UNAME='TEXT_SPC_LOAD_FNAME'  $
      ,FRAME=1 ,XOFFSET=3 ,YOFFSET=12 ,SCR_XSIZE=280 ,SCR_YSIZE=20  $
      ,/EDITABLE ,/ALL_EVENTS ,XSIZE=20 ,YSIZE=1)

  TEXT_SPC_LOAD_EXT = Widget_Text(BASE_SPC_LOAD, UNAME='TEXT_SPC_LOAD_EXT'  $
      ,FRAME=1 ,XOFFSET=300 ,YOFFSET=12 ,SCR_XSIZE=40 ,SCR_YSIZE=20  $
      ,/EDITABLE ,/ALL_EVENTS ,XSIZE=20 ,YSIZE=1, VALUE = [mcf_ext(0)])

  BUT_SPC_LOAD_FNAME_BROWSE = Widget_Button(BASE_SPC_LOAD,  $
      UNAME='BUT_SPC_LOAD_FNAME_BROWSE' ,XOFFSET=398 ,YOFFSET=6  $
      ,SCR_XSIZE=73 ,SCR_YSIZE=30 ,/ALIGN_CENTER ,VALUE='Browse')

  BUT_SPC_LOAD_DISPLAY_HDR = Widget_Button(BASE_SPC_LOAD,  $
      UNAME='BUT_SPC_LOAD_MORE' ,XOFFSET=484 ,YOFFSET=6  $
      ,SCR_XSIZE=112 ,SCR_YSIZE=25 ,/ALIGN_CENTER ,VALUE='Display more')

  TEXT_SPC_LOAD_HEADER = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_HEADER' ,XOFFSET=1 ,YOFFSET=45  $
      ,SCR_XSIZE=603 ,SCR_YSIZE=112 ,/SCROLL ,/EDITABLE ,XSIZE=20  $
      ,YSIZE=1)

  TEXT_SPC_LOAD_X_AXIS_TITLE = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_X_AXIS_TITLE' ,XOFFSET=7 ,YOFFSET=174  $
      ,SCR_XSIZE=88 ,SCR_YSIZE=18 ,VALUE=[ 'X-axis = column' ]  $
      ,XSIZE=20 ,YSIZE=1)

  TEXT_SPC_LOAD_X_AXIS = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_X_AXIS' ,XOFFSET=102 ,YOFFSET=172  $
      ,SCR_XSIZE=26 ,SCR_YSIZE=20 ,/EDITABLE ,/ALL_EVENTS ,VALUE=[  $
      strtrim(string(mcf_Xcol),2) ] ,XSIZE=15 ,YSIZE=1)

  TEXT_SPC_LOAD_Y_AXIS_TITLE = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_Y_AXIS_TITLE' ,XOFFSET=136 ,YOFFSET=174  $
      ,SCR_XSIZE=88 ,SCR_YSIZE=18 ,VALUE=[ 'Y-axis = column']  $
      ,XSIZE=20 ,YSIZE=1)

 TEXT_SPC_LOAD_Y_AXIS = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_Y_AXIS' ,XOFFSET=231 ,YOFFSET=172  $
      ,SCR_XSIZE=26 ,SCR_YSIZE=20 ,/EDITABLE ,/ALL_EVENTS ,VALUE=[  $
      strtrim(string(mcf_Ycol),2)] ,XSIZE=15 ,YSIZE=1)

  TEXT_SPC_LOAD_ROWS_TITLE = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_ROWS_TITLE' ,XOFFSET=266 ,YOFFSET=174  $
      ,SCR_XSIZE=68 ,SCR_YSIZE=18 ,VALUE=[ 'rows to skip']  $
      ,XSIZE=20 ,YSIZE=1)

 TEXT_SPC_LOAD_ROWS = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_ROWS' ,XOFFSET=340 ,YOFFSET=172  $
      ,SCR_XSIZE=26 ,SCR_YSIZE=20 ,/EDITABLE ,/ALL_EVENTS ,VALUE=[  $
      strtrim(string(mcf_rows),2)] ,XSIZE=15 ,YSIZE=1)

  BUT_SPC_LOAD_ALL = Widget_Button(BASE_SPC_LOAD,  $
      UNAME='BUT_SPC_LOAD_ALL' ,XOFFSET=410 ,YOFFSET=165  $
      , SENSITIVE = read_all_sens $
      ,SCR_XSIZE=70 ,SCR_YSIZE=30 ,/ALIGN_CENTER ,VALUE='READ ALL')

  BUT_SPC_LOAD_OK = Widget_Button(BASE_SPC_LOAD,  $
      UNAME='BUT_SPC_LOAD_OK' ,XOFFSET=490 ,YOFFSET=165  $
      ,SCR_XSIZE=50 ,SCR_YSIZE=30 ,/ALIGN_CENTER ,VALUE='OK')

  BUT_SPC_LOAD_CANCEL = Widget_Button(BASE_SPC_LOAD,  $
      UNAME='BUT_SPC_LOAD_CANCEL' ,XOFFSET=556 ,YOFFSET=165  $
      ,SCR_XSIZE=50 ,SCR_YSIZE=30 ,/ALIGN_CENTER ,VALUE='Cancel')

 TEXT_SPC_LOAD_LASTROW_TITLE = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_X_AXIS_TITLE' ,XOFFSET=0 ,YOFFSET=204  $
      , VALUE=[ 'LastRow displayed' ],SCR_XSIZE=94 ,SCR_YSIZE=18, XSIZE=30 ,YSIZE=1)

  TEXT_SPC_LOAD_LASTROW = Widget_Text(BASE_SPC_LOAD,  $
      UNAME='TEXT_SPC_LOAD_LASTROW' ,XOFFSET=100 ,YOFFSET=202  $
      ,SCR_XSIZE=26 ,SCR_YSIZE=20, /ALL_EVENTS ,VALUE=[  $
      '1' ] ,XSIZE=15 ,YSIZE=1)


if n_elements(mcf_lastfile) NE 0 then begin
	print, 'Lastfile = ', mcf_lastfile
	fname = mcf_lastfile
endif else fname = string(0)
if keyword_set(file) then fname = file
t = findfile(fname, count=t_count)
if t_count NE 0 then begin			; file exists - is it readable ?
	openr, iunit, fname, /get_lun
	text = ''
	readf, iunit, text
	WIDGET_CONTROL,TEXT_SPC_LOAD_HEADER, Set_value = text
	for i = 1, 6 do begin
		readf, iunit, text
		WIDGET_CONTROL,TEXT_SPC_LOAD_HEADER, Set_value = text, /append
	endfor
	close, iunit & free_lun, iunit
	WIDGET_CONTROL,TEXT_SPC_LOAD_FNAME, Set_value = fname
	mcf_lastfile = fname		; save for future use if valid text file
	mcf_lastrow = 6
endif
WIDGET_CONTROL,TEXT_SPC_LOAD_LASTROW, Set_value = strtrim(string(mcf_lastrow),2)

  SDF_ID = BASE_SPC_LOAD

  Widget_Control, /REALIZE, BASE_SPC_LOAD

  XManager, 'BASE_SPC_LOAD', BASE_SPC_LOAD

end
;-----------------------------------------------------------------
;
; Empty stub procedure used for autoloading.
;
function ax_file_load, file = file, ext = ext, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@axis_com

mcf = ' '
if keyword_set(file) then begin
	BASE_SPC_LOAD, GROUP_LEADER=wGroup, file=file, ext = ext, _EXTRA=_VWBExtra_
endif else begin
	BASE_SPC_LOAD, GROUP_LEADER=wGroup,ext = ext, _EXTRA=_VWBExtra_
endelse

return, mcf

end
