FUNCTION test

file=pickfile2(/read, title='Read Nicolet map file', filter='*.map')
openr, lun, file, /get_lun

; --- determine size & read-in all file
t =fstat(lun)
map_length = t.size/4
;print, 'length of file (in 32-bit reals = float*32)',map_length

mf=fltarr(map_length)
readu, lun, mf


; ------- skip 93*4 8-bit unsigned integers (uint8 in Matlab, byte in IDL)  --------
POINT_LUN, lun, 372	; position map file to start of info block
tmp=ulong(1)
readu, lun, tmp
print, 'pointer= ', tmp
indicblock = (tmp-204)/4
print, 'indicblock = ', indicblock
UWN = mf(indicblock+3);   ; upper wavenumber limit
LWN = mf(indicblock+4);   ; lower wavenumber limit
BGG = mf(indicblock+13);  ; gain background
IDF = mf(indicblock+17);  ; identifier for start indices of spectra
LAS = mf(indicblock+19);  ; Laser wavenumber
APT = mf(indicblock+22);  ; aperture size spectrometer
HPF = mf(indicblock+39);  ; high pass filter
LPF = mf(indicblock+40);  ; low pass filter
VEL = mf(indicblock+46);  ; mirror velocity
print, 'upper wavenumber= ', uwn
print, 'lower wavenumber= ', lwn
print, 'gain background= ', bgg
print, 'spectral start index= ', idf
print, 'Laser wavenumber= ', las
print, 'aperture size= ', apt
print, 'high pass filter= ', hpf
print, 'low pass filter= ', lpf
print, 'mirror velocity= ', vel

POINT_LUN, lun, indicblock*4	; position map file to start of info block
mint= ulonarr(13)
readu, lun, mint
NOD = Mint(0);             ;  NOD - number of data points
NMP = Mint(6);             ;  NMP - number of measurement points
IPP = Mint(7);             ;  IPP - interferogram peak position
NSS = Mint(8);             ;  NSS - number of sample scans
NPF = Mint(10);            ;  NPF - number of points for FFT
NGS = Mint(12);            ;  NGS - number of background scans
WVS  = (UWN-LWN)/(NOD-1);    ;  WVS - wavenumber step

print, '# of data points = ', nod
print, '#  of measurement points = ', nmp
print, '# of sample scans = ', nss
print, '# of points for FFT = ', npf
print, '# of background scans = ', ngs
print, 'interferogram peak position = ', ipp
WVS  = (UWN-LWN)/(NOD-1)
print, 'wavenumber step = ', wvs

; ------- get information about map -----------
POINT_LUN, lun, (indicblock+249)*4+2
mapprm = fltarr(6)
readu, lun, mapprm
Ystart = mapprm(0);
Ystop  = mapprm(1);
STY    = mapprm(2);           ; STY - step size in y direction
Xstart = mapprm(3);
Xstop  = mapprm(4);
STX    = mapprm(5);           ; STX - step size in x direction
SZY    = Ystop-Ystart;        ; SZY - map size in y-direction
SZX    = Xstop-Xstart;        ; SZX - map size in x-direction
YDI    = round(SZY/STY+1);    ; YDI - number of spectra in y-direction
XDI    = round(SZX/STX+1);    ; XDI - number of spectra in x-direction
XxY    = XDI * YDI;           ; XxY - number of spectra (equals xdim  * ydim)
print, 'X-step = ', stx
print, 'Y-step = ', sty
print, 'map size = ', szx, ' by ', szy
print, 'map dimensions = ', xdi, ' by ', ydi

; ------- locate start of spectral data block
t=where(mf EQ idf, count)
if count LE 0 then begin
	print, 'cannot find start of spectral block = ', idf
endif else $
    print, ' indices of spectal blocks = ', t

prog = 0
spcstart = t(1)+31
ctr = lonarr(2)
c = fltarr(nod-1, xxy)
for i=0, xxy-1 do begin
      ctr(0) = spcstart-NOD + (i+1)*(NOD+25)-1
      ctr(1) = ctr(0)+ NOD-2
;      print, ' spectrum ', i, ' from ', ctr(0),' to ', ctr(1)
      c(*,i) = mf(ctr(0):ctr(1))
; special patch for Michael C. Martin: checking whether the spectrum is a zero line spectrum
     if total(C(*,i)) EQ 0 then begin
      	tr = randomn(0.5, NOD)
      	C(*,i) = tr*0.0001
      endif
      progr   = (i+1)/XxY
      if (progr - prog) GT 0.01 then prog = progr
endfor

close, lun & free_lun, lun


return, c

end
