; Copyright (c) 1998-2008 A.P. Hitchcock  All rights reserved
;+
; FILE: refresh.pro
;
; LAST CHANGED: --------------------------------------- 26-Dec-07
;
; PURPOSE:
; Refresh
;	plot current sequence of buffers; update indicators
;
; ResetPlots
;	Reset the data in the temporary buffers
;
; COMMON BLOCKS
;	axis_com
;
; CALLED FROM:  axis_c

; ------------ revision history -----------------
; (03-jan-99 aph) added Zmax, Zmin impact
; ( 9-jul-99 aph) separated from axis_c.pro; fixed major error so now preserves scales
; (28-sep-99 aph) adapted to non-monotonic data
; (30-oct-99 aph) enabled overplots with buffer 0 NOT first file (o = 0 turns off overplot !!)
; (16-nov-99 aph) split our ResetPlots
; (26-Dec-07 aph) remove time/date
;-

PRO Refresh
@axis_com
on_error,2

HANDLE_VALUE, pData(0), tmp
IF n_tags(tmp) NE 0 THEN BEGIN
; ------------- re-plot first buffer using existing (x,y) scaling
	SetGraf,'MainImg'
    tmp.dl = tmp.dl ; + '   ' + strmid(systime(0),11,8) + '  '+strmid(systime(0),8,2)+'-'+strmid(systime(0),4,3) + '-'+strmid(systime(0),20,4)
	del = tmp.x(1:*) - tmp.x(0:*)
 	sect = where(del LT 0,n_plot)
 	if n_plot GT 0 then begin
 		PlotSect, pBufs(0), /AUTOSCALE
	endif else begin
	splot, tmp, color=bcolor(pBufs(0)), charsize=0.7, yrange = Yrng, $
		   thick=2, xstyle=1, ystyle=1, psym=Line_sym
	endelse
	SetGraf, 'MainImg', /SET

; ------------- plot subsequent buffers on same scaling
	IF pNum GE 1 then begin
	   	FOR i = 1, pNum - 1 DO BEGIN
	   		HANDLE_VALUE, pData(i), tmp
	   		del = tmp.x(1:*) - tmp.x(0:*)
 			sect = where(del LT 0,n_plot)
 			if n_plot GT 0 then begin
 				PlotSect,pBufs(i)
			endif else begin
				splot, tmp, /o, color = bcolor(pBufs(i)), charsize=0.7, $
				  yrange = Yrng, xstyle=1, ystyle=1, thick=2, psym=Line_sym
			endelse
		ENDFOR
; ------------- indicate the buffers plotted
		For i = 0, 9 DO BufStat(i) = 0
		For i = 0, pNum-1 DO BufStat(pBufs(i)) = 1
	  	WIDGET_CONTROL, BufButs, SET_VALUE = BufStat
	ENDIF
 ENDIF
 END
