; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_LOAD_LOGO
;
;LAST CHANGED: ----------------------------------- 07-Jan-10
;
;PURPOSE:
;	This procedure loads the image files used to display
; the rotating globe aXis2000 logo
;
;CATEGORY:
;	AXIS:  utility. Can be run stand alone for testing
;
;CALLING SEQUENCE:
;	AX_LOAD_LOGO, axis = axis, step = step
;
;CALLED FROM AXIS:
;	from ax_clear (used both at start-up and if all buffers cleared)
;
;INPUTS: none
;
;KEYWORDS:
;	AXIS - if set, indicates ax_load_logo was called from AXIS
;   STEP - loop step variable. If step=2 every second logo file is used
;
;OUTPUTS:
;	details of the logo are transferred to other programs via common
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;SIDE EFFECTS:
;	A set of 36 pixmaps - 18 Mb - is created.
;
;PROCEDURE:
;
;MODIFICATION HISTORY:
; (01-feb-00 aph) first version
; (20-feb-00 aph) merge read and pixmap
; (22-feb-00 aph) AXIS standard documentation
; (22-aug-01 aph) add tag in AXIS log window
; (12-may-02 aph) convert from tif (unsupported past IDL5.3) to png.
; (09-jul-02 aph) use rotate, not reverse for 5.5
; (03-jun-04 aph) change 'reverse (..., 3) to reverse(..., 2) for  IDL 6.0
; (14-jun-05 aph) add switch to get spin logo correct in IDL 4.2
; (07-Jan-10 aph) switch to 2010 logo
;-
pro ax_load_logo, axis = axis, step = step

@axis_com

if keyword_set(axis) then begin
	WIDGET_CONTROL, Uprompt, SET_VALUE=' ' , /append
	WIDGET_CONTROL, Uprompt, SET_VALUE=' Patience ! Loading logo . . .' , /append
	widget_control,/hourglass
endif
n_img = 37
ax_logo = bytarr(n_img,360,360, /nozero)
if NOT keyword_set(step) then step = 1

fname = strarr(n_img)
mask = CodePath +'logo\logoxxx.png'
xxx_pos = strpos(mask,'xxx')
for i = 0, n_img-1,step do begin
	ts = strmid(strcompress(string(1000 + i)),2,4)
	strput,mask,ts, xxx_pos
	fname(i) = mask
endfor

test = float(!version.release)
; print, 'IDL version ', test
;if test LT 5.3 then rev_val = 2 else rev_val = 1	; if rot_val = 7, rev_val = 1 or 2 - images are inverted
 if test LT 5.3 then rot_val = 0 else rot_val = 5	; found (1,5) values for IDL 6.x by trial and error !
;	print, 'rotate parameter = ', rot_val, ' Reverse parameter = ', rev_val

t=ax_name(fname(0))
site_file=t(0)+ 'logo-2010-sites.png'
tmp2 = read_png(site_file,R2,G2,B2)

start_time = systime(1)
; print, 'reading AXIS logo files . . . ', fname(0)
tmp = read_png(fname(0),R,G,B)
tmp = 255*tmp + tmp2
ax_logo(0,*,*) = rotate(tmp,rot_val)

; help, tmp

;  old was reverse(read_png(fname(0),R,G,B),3)  (aph 9-jul-02)
logo_R = r & logo_G = G & logo_B = B
TVLCT, R, G, B

if not keyword_set(axis) then begin
; ---------------- TESTING WITHOUT aXis2010 running ------for aXis2010  NOT WORKING -------
test = float(!version.release)
if test LT 5.3 then rot_val = 7 else rot_val = 8		; this is correct for Testing ! - in axis use reverse also

	for i = step,n_img-1,step do begin
		 tmp = read_png(fname(i),R,G,B)
		 tmp = 255*tmp + tmp2
		 TVLCT, R, G, B
		 ax_logo(i,*,*) = rotate(tmp,rot_val)
; old was reverse(read_png(fname(i)),3) (aph 9-jul-02)
	endfor
	stop_time = systime(1)
; ----- for testing purposes, fixed display ----------
	xs = 360  & ys = xs
	window, 0, xsize=xs, ysize=ys
	t = 0
	loops = 1
	ax_wait,/off
    axis_log, string(format='("Logo load time = ",f5.2," s")',stop_time - start_time)
	while t LT loops do begin
		t = t + 1
		for i = 0, n_img-1, step do begin
			 TVLCT, R, G, B
			tv, reform(ax_logo(i,*,*))
;			tv, rotate(reverse(reform(ax_logo(i,*,*)),rev_val),rot_val)
		endfor
	endwhile

endif else begin
; --------------------------  LOAD into aXis2010 ------------
; otherwise, transfer loaded images (ax_logo) back to axis_c
; which displays these until some other event is called
; and start display using timer mode

; load into pixmaps
	logo_num = n_img
	logo_now = 0
	logo_size = gr_scale*360
	logo_win = replicate(-1,logo_num)
	axis_log, '. . . loading AXIS logo . . . '
	for i = 0,logo_num-1, step do begin
		WINDOW, /FREE, XSIZE = logo_size, YSIZE = logo_size, /PIXMAP
        logo_win[i] = !D.WINDOW
        if logo_size LT 360 then begin
        	tmp=read_png(fname(i), R, G, B)
        	tmp = tmp + 255*tmp2
     		tmp = congrid(tmp, logo_size, logo_size)
			TVLCT, R, G, B
			tv, rotate(reverse(tmp,rev_val),rot_val)
		endif else begin
			pos = fix(0.5*(logo_size-360))
			tmp = read_png(fname(i), R, G, B)
			TVLCT, R, G, B
			tmp = tmp + 255*tmp2
			tv, rotate(reverse(tmp,rev_val),rot_val), pos, pos
		endelse
	endfor
	stop_time = systime(1)
    axis_log, string(format='("Logo load time = ",f5.2," s")',stop_time - start_time)
	logo_more = 1   ; MUST come at end as this activates XMANAGER in axis_c
endelse
end
