;NAME:
;	AA.pro
;
;LAST CHANGED: ----------------------------------- 28-feb-07
;
;PURPOSE:
; Main window interface for the XSpecSim program
;
;CATEGORY:
;	STAND ALONE: Spectra Prediction
;
;CALLED FROM AA:
;
;OUTPUTS:
;	A window for the X-SpecSim program
;
;COMMON BLOCKS:
;	@AA_Com		X-SpecSim common block
;-----------------------------------------------------------------

pro WID_BASE_0_event, Event
@aa_com
  wWidget =  Event.top

  case Event.id of

    Widget_Info(wWidget, FIND_BY_UNAME='cmdSimpleSum'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        SimpleSum, Event
      end
    Widget_Info(wWidget, FIND_BY_UNAME='cmdComplexSum'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        ComplexSum, Event
      end
    Widget_Info(wWidget, FIND_BY_UNAME='cmdLoadEnergy'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        LoadEnergy, Event
      end
    Widget_Info(wWidget, FIND_BY_UNAME='cmdLoadAAData'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        LoadAA, Event
      end
    Widget_Info(wWidget, FIND_BY_UNAME='cmdCancel'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        Cancel, Event
      end
    Widget_Info(wWidget, FIND_BY_UNAME='cmdLoadSequence'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        LoadSequence, Event
      end
    Widget_Info(wWidget, FIND_BY_UNAME='chkSaveSF'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        chkClick, Event
      end
    Widget_Info(wWidget, FIND_BY_UNAME='DropListData'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_DROPLIST' )then $
        DropListdatcb, Event
      end
    Widget_Info(wWidget, FIND_BY_UNAME='DropListEnergy'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_DROPLIST' )then $
        DropListencb, Event
      end
    else:
  endcase

end


pro WID_BASE_0, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@AA_Com
  Resolve_Routine, 'AA_eventcb'     ; Load event callback routines

  WID_BASE_0 = Widget_Base( GROUP_LEADER=wGroup, UNAME='WID_BASE_0'  $
      ,SCR_XSIZE=390 ,SCR_YSIZE=200 ,TITLE='XSpecSim -- peptide/protein NEXAFS spectrum predictor' ,SPACE=3 ,XPAD=3  $
      ,YPAD=3)

  WidDropDat = Widget_droplist(WID_Base_0, UNAME='DropListData'  $
      ,XOFFSET=290 ,YOFFSET=100 ,SCR_XSIZE=80 ,SCR_YSIZE=20  $
      ,/ALIGN_LEFT , VALUE=datafiles)

  WidDropEn = Widget_droplist(WID_Base_0, UNAME='DropListEnergy'  $
      ,XOFFSET=225 ,YOFFSET=100 ,SCR_XSIZE=60 ,SCR_YSIZE=20  $
      ,/ALIGN_LEFT , VALUE=enfiles)

  WID_LABEL_0 = Widget_Label(WID_BASE_0, UNAME='WID_LABEL_0'  $
      ,XOFFSET=6 ,YOFFSET=10 ,SCR_XSIZE=112 ,SCR_YSIZE=17  $
      ,/ALIGN_LEFT ,VALUE='Amino Acid Sequence')

  WIDTEXT = Widget_Text(WID_BASE_0, UNAME='WID_TEXT_0' ,XOFFSET=1  $
      ,YOFFSET=30 ,SCR_XSIZE=370 ,SCR_YSIZE=63 ,/EDITABLE $
      ,XSIZE=20 ,YSIZE=1,/NO_NEWLINE,/WRAP,/SCROLL )

  cmdSimpleSum = Widget_Button(WID_BASE_0, UNAME='cmdSimpleSum'  $
      ,XOFFSET=1 ,YOFFSET=100 ,SCR_XSIZE=93 ,SCR_YSIZE=20  $
      ,/ALIGN_CENTER ,VALUE='Uncorrected Spec')

  cmdComplexSum = Widget_Button(WID_BASE_0, UNAME='cmdComplexSum'  $
      ,XOFFSET=100 ,YOFFSET=100 ,SCR_XSIZE=120 ,SCR_YSIZE=20  $
      ,/ALIGN_CENTER ,VALUE='Peptide Bond Corrected')

  cmdLoadSequence = Widget_Button(WID_BASE_0, UNAME='cmdLoadSequence'  $
      ,XOFFSET=250 ,YOFFSET=5 ,SCR_XSIZE=120 ,SCR_YSIZE=20  $
      ,/ALIGN_CENTER ,VALUE='Load Sequence File')

  WID_LABEL_1 = Widget_Label(WID_BASE_0, UNAME='WID_LABEL_1'  $
      ,XOFFSET=4 ,YOFFSET=130 ,SCR_XSIZE=73 ,SCR_YSIZE=18  $
      ,/ALIGN_LEFT ,VALUE='Peptide Name:')

  ProteinName = Widget_Text(WID_BASE_0, UNAME='ProteinName_0'  $
      ,XOFFSET=77 ,YOFFSET=127 ,SCR_XSIZE=288 ,SCR_YSIZE=21  $
      ,/EDITABLE ,XSIZE=20 ,YSIZE=1)

  WidBase1 = Widget_Base(WID_BASE_0, UNAME='WIDBASE1' ,XOFFSET=0  $
      ,YOFFSET=152 ,SCR_XSIZE=60 ,SCR_YSIZE=20 ,TITLE='IDL' ,COLUMN=1  $
      ,/NONEXCLUSIVE)

  chkSaveSF = Widget_Button(WIDBASE1, UNAME='chkSaveSF'  $
      ,XOFFSET=0 ,YOFFSET=0 ,SCR_XSIZE=100 ,SCR_YSIZE=20  $
      ,/ALIGN_LEFT ,VALUE='Save SF ')

  cmdLoadEnergy = Widget_Button(WID_BASE_0, UNAME='cmdCancel'  $
      ,XOFFSET=280 ,YOFFSET=152 ,SCR_XSIZE=90 ,SCR_YSIZE=20  $
      ,/ALIGN_CENTER ,VALUE='Cancel')

  Widget_Control, /REALIZE, WID_BASE_0
  	Widget_Control, WidDropDat, SET_DROPLIST_SELECT=curdat
	widget_control, WidDropEn, SET_DROPLIST_SELECT=curen
	widget_control, chkSaveSF, SEt_Button=SaveSF

  XManager, 'WID_BASE_0', WID_BASE_0
end
;
; Empty stub procedure used for autoloading.
;
pro AA, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
  WID_BASE_0, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
@aa_com
end
