; Copyright (c) 1998-2002 C.J. Zimba  All rights reserved
;+
;NAME:
; 		READ_MAPPER
;
;LAST CHANGED: ----------------------------------- 	12-may-02
;
; PURPOSE:
;	This procedure reads in Zimba format alignment shifts.
;
; CATEGORY:
;	Image display.
;
; CALLING SEQUENCE:
;	READ_MAPPER, FILENAME, X, Y
;
; INPUTS:
; FILENAME	- name
; X		- array of X-shifts
; Y		- array of Y-shifts
; params - parameters
;
; KEYWORDS:
;	help=help
;   quiet=quiet
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;
; ROUTINES
; zstack_read_mapper_firstnum
;
; MODIFICATION HISTORY:
; (12-may-02 aph) AXIS standard header added
;-

;----- additional information ----
;   Extracts the data from Mapper files and stores it in the
;   float arrays x and y
;
;   Inputs
;   filename    the name of the mapper file to be read
;
;   Outputs
;   x   an array containing the x values from the Mapper file
;   y   an array containing the y values from the Mapper file.
;               this could be multidimensional...
;
;   Usage
;   read_mapper, filename, x, y
;
;   Warnings
;   Not assuming responsibility for misuse, or abuse of other file
;   types. Will not work if data plotted with the LINE command.
;
;   Completely rewritten Nov. 1997, CJJ
;   Renamed zstack_read_mapper.pro, making ZSTACK suite independent, feb2000, CGZ
;   Padded to input_string with leading zeroto ensure that it can be interpreted as a number, 19dec00 cgz

; This routine strips out the first stuff before a comma

FUNCTION zstack_read_mapper_firstnum, input_string, firstnum_string
IF (strlen(input_string) EQ 0) THEN BEGIN
    firstnum_string = ''
    return,0
ENDIF
comma_pos = strpos(input_string,',')
IF (comma_pos EQ (-1)) THEN BEGIN
    firstnum_string = input_string
    input_string = ''
ENDIF ELSE BEGIN
    firstnum_string = strmid(input_string,0,comma_pos)
    length = strlen(input_string)-comma_pos-1
    input_string = strmid(input_string,comma_pos+1,length)
ENDELSE
return,1
END
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO zstack_read_mapper, filename, x, y, params, help=help, quiet=quiet
IF (keyword_set(help) OR (n_elements(filename) EQ 0) OR $
    (n_params() EQ 0)) THEN BEGIN
    print, 'read_mapper,filename,x,y [/quiet]'
    print, '  If y has several points, you will get arrays like'
    print, '    x(n) and y(m,n)'
    return
ENDIF
filelist = findfile(filename)
svec = size(filelist)
IF (svec(0) EQ 0) THEN BEGIN
    print,'Could not open file "'+filename+'"'
    return
ENDIF
;on_ioerror,bailout
get_lun,lun
openr, lun, filename
;  Data for plotting in Mapper files is usually proceded by the PLOTIT
;  commmand.  To find the data, search for this command.
plotit_string = "PLOTIT("
input_string = ""
n_points = 0
n_y_data = 0
got_plotit = 0
this_num = 0.
params = ''
this_param = 0.
WHILE (NOT EOF(lun)) DO BEGIN
    readf, lun, input_string
; Data for alignment parameters,  added CGZ
;	used to display alignment parameters on ZSTACK Align dialog
;	when previously saved alignment shifts are used
	IF (strpos(strupcase(input_string), 'ALIGN(') NE (-1)) THEN BEGIN
		params_string = strmid(input_string, 1+strpos(strupcase(input_string), '('))
		WHILE (zstack_read_mapper_firstnum(params_string,this_param) NE 0) DO BEGIN
			IF (size(params,/n_dimensions) EQ 0) THEN BEGIN
				params = [float(this_param)]
			ENDIF ELSE BEGIN
				params = [params,float(this_param)]
			ENDELSE
		ENDWHILE
	ENDIF
    IF (got_plotit EQ 0) THEN BEGIN
        IF (strpos(strupcase(input_string), 'PLOTIT') NE (-1)) THEN BEGIN
            got_plotit = 1
        ENDIF
    ENDIF ELSE BEGIN
        ; We've had a PLOTIT command, so now we're reading data.
		input_string = '0'+input_string		; added to ensure that every input_string can be interpreted as a number , cgz
        IF (n_points EQ 0) THEN BEGIN
            IF (zstack_read_mapper_firstnum(input_string,numstr) EQ 0) THEN BEGIN
                goto,bailout
            ENDIF
            reads,numstr,this_num
            numbers = [this_num]
            WHILE (zstack_read_mapper_firstnum(input_string,numstr) NE 0) DO BEGIN
                reads,numstr,this_num
                numbers = [numbers,this_num]
            ENDWHILE
            x = [numbers(0)]
            n_y_data = n_elements(numbers)-1
            temp_y = [numbers(1:n_y_data)]
            n_points = 1
        ENDIF ELSE BEGIN
            IF (zstack_read_mapper_firstnum(input_string,numstr) EQ 0) THEN BEGIN
                goto,bailout
            ENDIF
            reads,numstr,this_num
            numbers = [this_num]
            WHILE (zstack_read_mapper_firstnum(input_string,numstr) NE 0) DO BEGIN
                reads,numstr,this_num
                numbers = [numbers,this_num]
            ENDWHILE
            x = [x,numbers(0)]
            IF (n_y_data NE (n_elements(numbers)-1)) THEN BEGIN
                print,'Inconsistent number of Y points'
                goto,bailout
            ENDIF
            temp_y = [temp_y, numbers(1:n_y_data)]
            n_points = n_points+1
        ENDELSE
    ENDELSE
ENDWHILE
; Now rearrange the data
IF (n_y_data EQ 1) THEN BEGIN
    y = temp_y
ENDIF ELSE BEGIN
    y = fltarr(n_y_data,n_points)
    lindgen_list = lindgen(n_points)
    FOR i_data = 0, (n_y_data-1) DO BEGIN
        index_list = long(i_data) + long(n_y_data) * lindgen_list
        y(i_data,0:(n_points-1)) = temp_y(index_list)
    ENDFOR
ENDELSE
bailout:
close,lun
free_lun,lun
return
END