;+ 
; 
; Copyright (c) 1999, Adam Hitchcock  All rights reserved. 
;	Unauthorized reproduction prohibited. 
; 
; NAME: 
;	READ_AXM 
; 
; PURPOSE: 
;	This function reads a mapper 1-d data file,  into 
;   the standard 1d structure used internally in AXIS (ALS format) 
; 
; CATEGORY: 
;	Data analysis / conversion: 
; 
; CALLING SEQUENCE: 
; 
;	Result = READ_AXM() 
; 
; INPUTS: 
; 
; OPTIONAL INPUTS: 
;	Parm2:	Describe optional inputs here. If you don't have any, just 
;		delete this section. 
; 
; KEYWORD PARAMETERS: 
;	FILE:  provides filename and thus pickfile dialog not launched (/silent) 
; 
; OUTPUTS: 
;	Describe any outputs here.  For example, "This function returns the 
;	foobar superflimpt version of the input array."  This is where you 
;	should also document the return value for functions. 
; 
; OPTIONAL OUTPUTS: 
;	Describe optional outputs here.  If the routine doesn't have any, 
;	just delete this section. 
; 
; COMMON BLOCKS: 
;	@axis_com 
; 
; SIDE EFFECTS: 
;	Describe "side effects" here.  There aren't any?  Well, just delete 
;	this entry. 
; 
; RESTRICTIONS: 
;	Describe any "restrictions" here.  Delete this section if there are 
;	no important restrictions. 
; 
; PROCEDURE: 
;	uses X1A READ_MAPPER routine to read mapper file 
; 
; EXAMPLE: 
 
;	Can be used as stand-alone (in which case a structure is returned 
;	 or as part of AXIS widget. 
; 
;		tmp = read_axm() 
; 
; MODIFICATION HISTORY: 
; 	Written by:	Adam Hitchcock - AXIS-wrapper for Jacobsen read_mapper routine. Date. 15-Sep-99 
; 
;- 
Function READ_AXM, file = file 
 
on_error,2 
@axis_com
 
null='' 
 
if NOT keyword_set(file) then begin 
	map_file = pickfile2(/read,filter='*.map', DEFPATH=DefPath, /Lpath) 
	if map_file EQ '' then return, null 
endif else map_file = file 
 
read_mapper, map_file, t_x, t_y 
dln = ax_name(map_file) 
 
s={t:'1d', d: t_y, x: t_x, xl: 'x', dn: t_x, dl:dln(1)} 
 
print, 'Read mapper file from', map_file 
return, s 
 
END