; Copyright (c) 1998-2010 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		PICKFILE2
;
;LAST CHANGED: ----------------------------------- 	20 April 2010
;
; PURPOSE:
;	This function is a dialog which allows user to select a filename.
;   It is a wrapper over the old IDL PICKFILE dialog
;    with last path, last file options and forcing extension
;
; CATEGORY:
;	utility. stand alone
;
; CALLING SEQUENCE:
;	Result = PICKFILE2 (LPATH=lp, TITLE=TITLE, $
;                       WRITE=write, LFILE=lf, INFO=info, _extra=e)
;
; INPUTS: none
;
; KEYWORDS:
;	FILTER - extension (*.hdr)
;	INFO - print info on this routine
;	LPATH - last path used
;	LFILE - last file used
;	TITLE - user supplied title for dialog
;	WRITE - if set, when selecting a filename, checks & warns for existence
;
; OUTPUTS: none
;
; COMMON BLOCKS:
;	AXIS_COM	standard set of common blocks
;	common lastpath, lpath, lfile
;
; MODIFICATION HISTORY:
; (06-jul-98 aph) force DefPath to be LastPath from exit
; (04-jan-00 aph) add WRITE, AXIS keywords and build a wrap that warns user of overwriting
; (25-apr-00 aph) attempt to get lpath working properly; allow use outside of axis
; (19-apr-01 aph) add TITLE
; (14-may-02 aph) AXIS standard header added; force filter extension
; (22-nov-08 aph) use axis_log for warnings
; (20-Apr-10 aph) remove 'forcing extension' warning
;-

function PICKFILE2, LPATH=lp, filter=filter, TITLE=TITLE, WRITE=write, $
         LFILE=lf, INFO=info, _extra=e
@axis_com
common lastpath, lpath, lfile
on_error,2

if n_elements(lpath) eq 0 then lpath=defpath
if keyword_set(info) then print, 'Last Path:', lpath
if not keyword_set(lf) then lfile=''
if n_elements(lf) eq 0 then lfile=''
if keyword_set(info) then print, 'Last File:', lfile
if not keyword_set(title) then title = 'Select file'
gpath=''
pick_again:
file=PICKFILE( PATH=lpath, GET_PATH=gpath, FILE=lfile, $
               filter=filter, title=title, /noconfirm, _extra=e)
if strlen(file) EQ 0 then return, file
; ------ force extension same as filter
if keyword_set(filter) AND keyword_set(write) then begin
	t = ax_name(file)
	t2 = ax_name(filter)
;	print, ' forcing exension to ', '.' + t2(2)
	file = t(0) + t(1) + '.' + t2(2)
endif
; ------ check if this file already exists [ ONLY if writing - i.e. /write keyword)
if overwrite_all EQ 1 then goto, continue	; do not check if switched for all files
if keyword_set(write) then begin
	test = findfile(file)
	if test(0) EQ file then begin
		t=ax_name(file)
		fileshort = t(1) + '.' + t(2)
		axis_log, ' WARNING: ' + fileshort + ' already exists. Overwrite ?'
		if widget_info(/active) EQ 1 then begin  ; assumes if a widget is used, it is AXIS
			dec = file_overwrite(val=1, group = axis_ID)
		endif else  dec = file_overwrite( val=1)
		if dec EQ 0 then goto, pick_again
		if dec EQ 2 then overwrite_all = 1
	endif
endif
continue:
if keyword_set(info) then print, 'New Path: ', gpath
if file NE '' then begin
	defpath = gpath
	lpath = gpath
	lfile = file
endif
return, file
end


