; Copyright (c) 1998-2001 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_SDF_EVENTCB
;
;LAST CHANGED: ----------------------------------- 04-nov-01
;
;PURPOSE:
;	This set of procedures constitute a widget to read in files
; in the ascii self defining format (SDF) developed for ALS BL5.3.2 STXM. The widget uses
; read_sdf and parse_sdf to perform the file input.
;
;CATEGORY:
;	AXIS: utility
;
; AX_SDF_EVENT ROUTINES:
; TEXT_SDF_FNAME		modify filename; when changed, execute READ_SDF
; BUT_SDF_FNAME_BROWSE 	browse for new filename
; BUT_SDF_OK			proceed with loading SDF file into AXIS
; BUT_SDF_CANCEL		abort read in
; WID_DLIST_CHANNEL		drop list used to display and select the data channel
; WID_DLIST_REGION		drop list to display and select region
; ax_sdf_eventcb		auto loading stub
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;	@SDF_COM 	structure with header info
;
;MODIFICATION HISTORY:
; (25-feb-01 aph) first written using IDL 5.2 GUIBuilder
; (27-jun-01 aph) add groupID for better feedback on reads
; (29-jul-01 aph) add regions selector to the panel; introduced sdf_com; reverted to pickfile2
; (19-aug-01 aph) adapt to regions change & change in structure names; define regions & channels
; (04-nov-01 aph) add sdf_lastfile to sdf_com to save last name
;-

pro TEXT_SDF_FNAME, Event
on_error,2
@axis_com
@sdf_com
; get the changed name
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SDF_FNAME')
WIDGET_CONTROL,id, Sensitive=1, Get_value = fname
sdf_lastfile = fname
; update details
BUT_SDF_FNAME_BROWSE, Event, file = fname
end

;-----------------------------------------------------------------
pro BUT_SDF_FNAME_BROWSE, Event, file=file
on_error,2
@axis_com
@sdf_com
; get new filename
if NOT keyword_set(file) then begin
	fname = pickfile2(Title='Select SDF file', Filter = '*.hdr')
endif else fname = file
if strlen(fname) GT 0 then begin
sdf_lastfile = fname	; ensure the filename is saved for future use
; update name in the text box
	id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SDF_FNAME')
	WIDGET_CONTROL,id, Set_value = fname

; ----------- start display without active displays / controls
	id = widget_info(Event.top, FIND_BY_UNAME ='BUT_SDF_DISPLAY_HDR')
  widget_control, id, sensitive = 1

; read file and update type
	widget_control, /hourglass
	sdf = read_sdf(fname, /header_only)
; update the type
	id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SDF_TYPE')
	WIDGET_CONTROL,id, Sensitive=1, Set_value = sdf.Type
;  ------------- update data channel information
	nchnl = n_elements(sdf.Channel_labels)
	SDF_Channel_List = strarr(nchnl)
	for i = 0, nchnl(0)-1 do SDF_Channel_List(i) = sdf.Channel_labels[i].Name
	id = widget_info(Event.top, FIND_BY_UNAME = 'WID_DLIST_CHANNEL')
	WIDGET_CONTROL,id, Set_VALUE = SDF_Channel_List, sensitive = 1
; ------------- update region information
; currently there are no names associated with regions; can only set number of elements
	n_regions = sdf.n_regions
	if n_regions GT 1 then SDF_region_List = strarr(n_regions+1) else SDF_region_List = ' '
	for i = 0, n_regions-1 do SDF_Region_List(i) = 'Region '+ strtrim(string(i+1),2)
	if n_regions GT 1 then SDF_Region_List(n_regions) = 'all regions'
	id = widget_info(Event.top, FIND_BY_UNAME = 'WID_DLIST_REGION')
	WIDGET_CONTROL,id, Set_VALUE = SDF_Region_List, Sensitive=1
endif
end

pro WID_DLIST_CHANNEL, Event
on_error,2
@axis_com
@sdf_com
; get the changed data channel
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_DLIST_CHANNEL')
WIDGET_CONTROL,id, Sensitive=1, Get_value = sdf_ch
WIDGET_CONTROL,id, SET_DROPLIST_SELECT = sdf_ch
end

pro WID_DLIST_REGION, Event
on_error,2
@axis_com
@sdf_com
; get the changed region
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_DLIST_REGION')
WIDGET_CONTROL,id, Sensitive=1, Get_value = sdf_region
WIDGET_CONTROL,id, SET_DROPLIST_SELECT = sdf_region
end

;-----------------------------------------------------------------
pro BUT_SDF_DISPLAY_HDR, Event, group=wGroup
on_error,2
@axis_com
@sdf_com
; get the header filename
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SDF_FNAME')
WIDGET_CONTROL,id, Get_value = fname
if strlen(fname(0)) GT 0 then begin
	t = ax_name(fname(0))
	fname = t(0) + t(1) + '.hdr'
	XDisplayfile,fname, group = wGroup
endif
end

;-----------------------------------------------------------------
pro BUT_SDF_OK, Event
on_error,2
@axis_com
@sdf_com
; get the  name
id = widget_info(Event.top, FIND_BY_UNAME = 'TEXT_SDF_FNAME')
WIDGET_CONTROL,id, Sensitive=1, Get_value = fname
; get the data channel
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_DLIST_CHANNEL')
sdf_ch = WIDGET_INFO(id, /Droplist_select)
nchnls = n_elements(sdf_ch)
widget_control, /hourglass

; get the region
n_regions = sdf.n_regions
id = widget_info(Event.top, FIND_BY_UNAME = 'WID_DLIST_REGION')
sdf_region = WIDGET_INFO(id, /Droplist_select)
region = sdf_region(0) + 1
if  region LE n_regions then begin
; read the data file for a defined region
	print, 'Reading channel ', string(sdf_ch(0)+1,format='(i2)'), 'of ', string(nchnls,format='(i2)'), $
	' channels.  Region ', string(region,format='(i2)'), 'of ', string(n_regions,format='(i2)'), ' regions.'
	sdf = read_sdf(fname(0), channel=sdf_ch(0)+1, region = region, group=SDF_ID)
endif else begin		; read all regions
	sdf = read_sdf(fname(0), channel=sdf_ch(0)+1, /all_regions, group=SDF_ID)
endelse

WIDGET_CONTROL, Event.Top, /DESTROY
return
end

;-----------------------------------------------------------------

pro BUT_SDF_CANCEL, Event
@axis_com
@sdf_com
on_error,2
sdf = 0
WIDGET_CONTROL, Event.Top, /DESTROY
end

; ----------------------
; Empty stub procedure used for autoloading.
;
pro ax_sdf_eventcb
end

;-----------------------------------------------------------------
; ****************************************************************
;-----------------------------------------------------------------

pro BASE_SDF_event, Event
@axis_com
@sdf_com

  wWidget =  Event.top

  case Event.id of

    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SDF_FNAME'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_SDF_FNAME, Event
    end
      Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SDF_CHANNEL'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_SDF_CHANNEL, Event
    end
      Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SDF_REGION'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_STR' )then $
        TEXT_SDF_REGION, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SDF_FNAME_BROWSE'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SDF_FNAME_BROWSE, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='TEXT_SDF_TYPE_TITLE_0'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_TEXT_DEL' )then $
        BUT_SDF_FNAME_BROWSE, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SDF_DISPLAY_HDR'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SDF_DISPLAY_HDR, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SDF_OK'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SDF_OK, Event
    end
    Widget_Info(wWidget, FIND_BY_UNAME='BUT_SDF_CANCEL'): begin
      if( Tag_Names(Event, /STRUCTURE_NAME) eq 'WIDGET_BUTTON' )then $
        BUT_SDF_CANCEL, Event
    end
    else:
  endcase

end

pro BASE_SDF, GROUP_LEADER=wGroup,  file=file, _EXTRA=_VWBExtra_
@sdf_com
  Resolve_Routine, 'ax_sdf_eventcb'     ; Load event callback routines
t = size(wGroup)
IF t(1) EQ 0 THEN modal_val=0 else modal_val=1

;print, wgroup, 'modal_val = ' , modal_val

  BASE_SDF = Widget_Base( GROUP_LEADER=wGroup, UNAME='BASE_SDF'  $
      ,SCR_XSIZE=521 ,SCR_YSIZE=126 ,TITLE='Read Self Defining Format'+ $
      ' files' ,SPACE=3 ,XPAD=3 ,YPAD=3,  modal = modal_val)
  TEXT_SDF_FNAME = Widget_Text(BASE_SDF, UNAME='TEXT_SDF_FNAME'  $
      ,FRAME=1 ,XOFFSET=110 ,YOFFSET=11 ,SCR_XSIZE=234 ,SCR_YSIZE=20  $
      ,/EDITABLE ,/ALL_EVENTS ,XSIZE=20 ,YSIZE=1)
  TEXT_SDF_FNAME_TITLE = Widget_Text(BASE_SDF,  $
      UNAME='TEXT_SDF_FNAME_TITLE' ,XOFFSET=26 ,YOFFSET=12  $
      ,SCR_XSIZE=75 ,SCR_YSIZE=18 ,/ALL_EVENTS ,VALUE=[ 'File name' ]  $
      ,XSIZE=20 ,YSIZE=1)
  BUT_SDF_FNAME_BROWSE = Widget_Button(BASE_SDF,  $
      UNAME='BUT_SDF_FNAME_BROWSE' ,XOFFSET=357 ,YOFFSET=10  $
      ,SCR_XSIZE=73 ,SCR_YSIZE=23 ,/ALIGN_CENTER ,VALUE='Browse')
  TEXT_SDF_TYPE_TITLE_0 = Widget_Text(BASE_SDF,  $
      UNAME='TEXT_SDF_TYPE_TITLE_0' ,XOFFSET=24 ,YOFFSET=45  $
      ,SCR_XSIZE=75 ,SCR_YSIZE=18 ,/ALL_EVENTS ,VALUE=[ 'Type', '',  $
      '', '' ] ,XSIZE=20 ,YSIZE=1)
  TEXT_SDF_TYPE = Widget_Text(BASE_SDF, UNAME='TEXT_SDF_TYPE'  $
      ,XOFFSET=113 ,YOFFSET=46 ,SCR_XSIZE=189 ,SCR_YSIZE=18  $
      ,EDITABLE=0 ,/ALL_EVENTS ,VALUE=[ 'Type', '', '', '' ] ,XSIZE=20  $
      ,YSIZE=1)
  BUT_SDF_DISPLAY_HDR = Widget_Button(BASE_SDF,  $
      UNAME='BUT_SDF_DISPLAY_HDR' ,XOFFSET=320 ,YOFFSET=42  $
      ,SCR_XSIZE=112 ,SCR_YSIZE=28 ,/ALIGN_CENTER ,VALUE='Show parameters')
  BUT_SDF_OK = Widget_Button(BASE_SDF, UNAME='BUT_SDF_OK'  $
      ,XOFFSET=454 ,YOFFSET=12 ,SCR_XSIZE=50 ,SCR_YSIZE=48  $
      ,/ALIGN_CENTER ,VALUE='OK')
  BUT_SDF_CANCEL = Widget_Button(BASE_SDF, UNAME='BUT_SDF_CANCEL'  $
      ,XOFFSET=454 ,YOFFSET=66 ,SCR_XSIZE=50 ,SCR_YSIZE=30  $
      ,/ALIGN_CENTER ,VALUE='Cancel')

  SDF_Channel_List =['PMT','OSA','Analog']
  SDF_Ch = 0
  WID_DLIST_CHANNEL = Widget_Droplist(BASE_SDF,  $
      /DYNAMIC_RESIZE, VALUE = SDF_Channel_List, $
      UNAME='WID_DLIST_CHANNEL' ,XOFFSET=21 ,YOFFSET=72,  $
      TITLE='Data Channel')
  SDF_Region_List =['region 1']
  SDF_region = 0
  WID_DLIST_REGION = Widget_Droplist(BASE_SDF,  $
      /DYNAMIC_RESIZE, VALUE = SDF_Region_List, $
      UNAME='WID_DLIST_REGION' ,XOFFSET=200 ,YOFFSET=72,  $
      TITLE='Region')
; ----------- start display without active displays / controls
  widget_control, WID_DLIST_CHANNEL, sensitive = 0
  widget_control, WID_DLIST_REGION, sensitive = 0
  widget_control, TEXT_SDF_TYPE, sensitive = 0
  widget_control, BUT_SDF_DISPLAY_HDR, sensitive = 0
  Widget_Control, /REALIZE, BASE_SDF

; ------ set last file name
  t = size(sdf_lastfile,/type)
;  print, 'loading last name (size) ', sdf_lastfile, t
  if t(0) NE 0 then   widget_control, TEXT_SDF_FNAME, set_value = sdf_lastfile

  XManager, 'BASE_SDF', BASE_SDF

  SDF_ID = BASE_SDF
  if keyword_set(file) then begin
	print, 'still cannot preload files'
  endif

end

; ------------------

function ax_sdf, file = file, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
on_error,2
@axis_com
@sdf_com

; BASE_SDF, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_

sdf = ' '
if keyword_set(file) then begin
	BASE_SDF, GROUP_LEADER=wGroup, file=file, _EXTRA=_VWBExtra_
endif else begin
	BASE_SDF, GROUP_LEADER=wGroup, _EXTRA=_VWBExtra_
endelse

return, sdf
end
