; Copyright (c) 1998, ALS SpectroMicroscopy Facility, jdd
;
;file: srotate.pro
;
;+
;   fct SROTATE, struc, [dir , /Trans, /NORM, LABELS=[xlabel, ylabel'], _extra=e]
;       -- rotate 2D structure (and dn: subfield) using ROTATE and 
;				appropriately exchange and reverse the axis arrays and labels
;		  dir =  direction # [0-7] as defined by ROTATE:
;				  0 deg:		0  [ X, Y]		+ Transpose:   4  [ Y, X]
;				 90 deg:  	1  [-Y, X]		+ Transpose:   5  [-X, Y]
;				180 deg:  	2  [-X,-Y]		+ Transpose:   6  [-Y,-X]
;				270 deg:  	3  [ Y,-X]		+ Transpose:   7  [ X,-Y]
;		 Options:
;			/Trans - transpose X & Y axes  (dir=4)
;			/Hflip - horizontal flip  (dir=5)
;			/Vflip - vertical flip (dir=7), (dir=2, both Hflip & Vflip)
;-

function SROTATE, s, dir, TRANS=trans, HFLIP=hflip, VFLIP=vflip
;===========================================
; rotate 2D structure and the labels
; return 1D or 2D structure: {d:, x:, dl:, xl:} or {d:, x:, y:, dl;, xl:, yl:}
on_error,2

if n_elements(dir) eq 0 then dir=0
if keyword_set(trans) then dir=4
if keyword_set(hflip) then dir=5
if keyword_set(vflip) then dir=7
if keyword_set(hflip) and keyword_set(hflip) then dir=2

dat=ROTATE( s.d, dir )

case dir of
0: begin & xarr=s.x          & xlbl=s.xl & yarr=s.y          & ylbl=s.yl & end
1: begin & xarr=reverse(s.y) & xlbl=s.yl & yarr=s.x          & ylbl=s.xl & end
2: begin & xarr=reverse(s.x) & xlbl=s.xl & yarr=reverse(s.y) & ylbl=s.yl & end
3: begin & xarr=s.y          & xlbl=s.yl & yarr=reverse(s.x) & ylbl=s.xl & end
4: begin & xarr=s.y          & xlbl=s.yl & yarr=s.x          & ylbl=s.xl & end
5: begin & xarr=reverse(s.x) & xlbl=s.xl & yarr=s.y          & ylbl=s.yl & end
6: begin & xarr=reverse(s.y) & xlbl=s.yl & yarr=reverse(s.x) & ylbl=s.xl & end
7: begin & xarr=s.x          & xlbl=s.xl & yarr=reverse(s.y) & ylbl=s.yl & end
else:
endcase

if stag(s,'dn') then begin
   datn=ROTATE( s.dn, dir )
   snew={d:dat, dn:datn, x:xarr, y:yarr, dl:s.dl, dnl:s.dnl, xl:xlbl, yl:ylbl}
endif else begin
   snew={d:dat, x:xarr, y:yarr, dl:s.dl, xl:xlbl, yl:ylbl}
endelse

return, snew
end

