; Copyright (c) 1996, ALS SpectroMicroscopy Facility, jdd 
;  **** *********** splot3d removed ****** rel to jdd's version (splot) ******* 
;+ 
; FILE: splota.pro 
; 
; last changed: ------------------------------  30-nov-00
; 
; REQUIREMENTS:  graph.pro MUST be compiled prior 
; 
; CONTENTS: 
;  pro SPLOT2D, s2  [, /ASPECT, opt]	-- image plot with axes 
;      options: /ASPECT rescale window vertical size to 
;                       aspect ratio similar to the image dimensions 
;               /ZOOM allows user to define x,y ranges 
;               _extra=e - pass along PLOT options 
; 
; INPUTS 
;     basic input data structure: s2={d:, x:, y:} 
;     optional axis and title label fields include {xl:, yl:, dl:} 
; 
; COMMON: axis_com 
; 
; REVISIONS 
; 2/19/96  initial creation 
; 6/15/96  jdd added generalized interpretation of structures 
;              in SPLOT, SPLOT2D, SPLOT3D 
;              separated splot stuff from graph.pro 
; 6/29/96  aph allow numerical limts on ranges 
; (06-Dec-97 aph) remove print of ytitle 
; (03-jan-99 aph) add back in YTitle (!!) 
; (24-jun-99 aph) consistent image/spectra color tables 
; (13-aug-99 aph) no change - just using debugs to track reform problem 
; (14-nov-00 cgz) migrated from SPLOTA.PRO
; (15-nov-00 cgz) Replaced call of NCOLS function by explicit (SIZE(var))(1)
; (30-nov-00 cgz) Replaced call of WSIZE function by explicit [!D.X_SIZE,!D.Y_SIZE]
; (30-nov-00 cgz) Replaced call of nwin with explicit window statement
;- 
 
 
pro splot2d, s, ASPECT=asp,ZOOM=zoom, _extra=e 
;------------------------ 
; basic 2-D structure contains {d:, x:, y:} fields 
; optional label fields { dl:, xl:, yl:} 
; options: /ASPECT rescale window vertical size to 
;          aspect ratio similar to the image dimensions 
;          /ZOOM allows user to define x,y ranges 
 
@axis_com
on_error,2 
 
dl='' & xl='' & yl='' 
fexist=stag(s, ['dl', 'xl', 'yl']) 
if fexist(0) then dl=s.dl 
if fexist(1) then xl=s.xl 
if fexist(2) then yl=s.yl 
 
; determine indices of s.d within xrange, yrange 
nxb=0 
xmin=s.x(0) 
;nxe=ncols(s.x)-1 
nxe=(size(s.x))(1)-1 
xmax=s.x(nxe) 
nyb=0 
ymin=s.y(0) 
;nye=ncols(s.y)-1 
nye=(size(s.y))(1)-1 
ymax=s.y(nye) 
if keyword_set(zoom) then begin 
	prom=string(s.x(0)) + ' Xmin:' 
	READ, xmin, PROMPT= prom 
	prom=string(s.x(nxe)) + ' Xmax:' 
	READ, xmax, PROMPT= prom 
	prom=string(s.y(0)) + ' Ymin:' 
	READ, ymin, PROMPT= prom 
	prom=string(s.y(nye)) + ' Ymax:' 
	READ, ymax, PROMPT= prom 
;	for i=0, ncols(s.x)-1 do begin 
	for i=0, (size(s.x))(1)-1 do begin 
	   if s.x(i) le xmin then nxb=i 
	   if s.x(i) lt xmax then nxe=i 
	   if s.y(i) le ymin then nyb=i 
	   if s.y(i) lt ymax then nye=i 
	endfor 
endif 
 
if keyword_set(asp) then begin 
   sz=size(s.d) 
   dx=abs(xmax-xmin) 
   dy=abs(ymax-ymin) 
   aspect=dy/dx*1.2 
   print, dx, dy, aspect/1.2 
;   ws=wsize() 
	ws = [ !D.X_SIZE, !D.Y_SIZE ] 
;   nwin, !d.window+(!d.window eq -1), ws(0), round(ws(0)*aspect) 
   window, !d.window>0, xsize=ws(0), ysize=round(ws(0)*aspect) 
endif 
plot2d, s.d(nxb:nxe,nyb:nye), s.x(nxb:nxe), s.y(nyb:nye), [xl, yl], title=dl, _extra=e 
 
end 
 
 
