; Copyright (c) 1998-2007 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AXIS_COM.PRO
;
;LAST CHANGED: ----------------------------------- 11-mar-07
;
;PURPOSE:
;	This INCLUDE file contains COMMON blocks for AXIS.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE: @axis_com
;
; NAMES AND MEANING OF COMMON VARIABLES
; *************************************************************************
; ***********         AXIS COMMON PARAMETERS             ******************
; *************************************************************************
;
; CAUTION - if you use one of these variable names in a subroutine for
; a different purpose and have included @axis_com, this can be a source
; of hard to trace errors in other routines. A common cuplrit is DATA.
;
;COMMON aDRAWID,    Axis_ID, MainWid, MainImg, XZPlot, YZPlot, Thumbnails, AxSpin
;	Axis_ID		ID of AXIS widget base
;	MainWid		graphics window # of draw window (not same as Widget ID !!)
;	MainImg		ID of MainImg draw window
;	XZPlot		graphics window #  of XZ line-out draw window
;	YZPlot		graphics window #  of XZ line-out draw window
;   ColorbarPlot graphics window #  of colorbar draw window
;	Thumbnails	graphics window #  of Thumbnails draw window
;	AxSpin		= 1 if using spinning globe logo; = 0 if single image
;COMMON aBUF, CurBuf, Data, pData, pNum, pBufs, BufStat, ButIDs, BufButs, OptButs
;	CurBuf		number of current buffer (0-12; only 0-9 directly displayable)
;	Data		pointers to the data structures
;	pData		pointers to spectra components for overplotting
;	pNum		number of plots in temporary storage for overplotting
;	pBufs		original buffers of overplot files (order scrambled by user sleection in overplotting)
;	BufStat		status of displayed buffers (multiple buffer display in overplot)
;	ButIDs		ID values of the buffer labels
;	BufButs		ID values of the buffer selection boxes
;	OptButs		ID values of the option buttons
;COMMON BufScal,    Xscl,Yscl, Zscl,  Xmin, Xmax, Ymin, Ymax, Zmin, Zmax, G_slider
;	Xscl		Array of (xmin, xmax) for all 10 buffers
;	Yscl		Array of (ymin, ymax) for all 10 buffers
;	Zscl		Array of (zmin, zmax) for all 10 buffers
;	Xmin		Widget ID for Text box with user selectable Xmin (15-Nov-99)
;	Xmax		Widget ID for Text box with user selectable Xmax (15-Nov-99)
;	Ymin		Widget ID for Text box with user selectable Ymin (15-Nov-99)
;	Ymax		Widget ID for Text box with user selectable Ymax (15-Nov-99)
;	Zmin		Widget ID for Text box with user selectable Zmin (20-Dec-98)
;	Zmax		Widget ID for Text box with user selectable Zmax (20-Dec-98)
;	G_slider	Widget ID for gamma slider control (16-nov-99)
;COMMON aPATHS,  DefPath, WritePath, ini_file, codepath, last_image_ext,location
;	DefPath		path for READING datafiles
;	WritePath	path for Writing data files
;	ini_file	name of program paramaters
;	codepath	path to code files
;   last_image_ext  extension (data type) of last image read by axis (default *.im1)
;	location	physical location (used as switch for some spcific cases)
;COMMON aPRINT,  gr_dev, gr_scale, Print_dev, Pr_Command, print_file
;	gr_dev		IDL device for screen display ('WIN', 'X')
;	gr_scale	graphics scal factor (0.5 to 2.0)
;	Print_dev	IDL device for printing ('PS'=postscript, 'PCL'=HP PCL language)
;	Pr_Command	command to transfer file to printer   (11-May-99)
;	print_file	name of print file
;	Help_cmd	command to load acrobat file (axis.pdf)  (24-may-99)
;   Net_command command to start web browser (31-jan-00)
;COMMON aCURS1,	CursorX, CursorY, CursorZ, PixelX, PixelY, xline, yline, Xval, Yval, Zval
;	CursorX		widget ID for x value display
;	CursorY		widget ID for y value display
;	CursorZ		widget ID for z value display
;	PixelX		widget ID of x pixel value display
;	PixelY		widget ID of y pixel value display
;	xline		[x1, x2] data values for user selected line
;	yline		[y1, y2] data values for user selected line
;	Xval		x value of cursor
;	Yval		y value of cursor
;	Zval		z value of cursor
;COMMON aCURS2,	GraphFrozen, CurFroz, CurX, CurY, Xrng, Yrng, Zrng
;	GraphFrozen	switch indicating MainImg cursor nor active (NO LONGER USED)
;	CurFroz		[x,y] values where MainImg cursor is frozen
;	CurX		x-cursor index (device)
;	CurY		y-cursor index (device)
;	Xrng		[Xmin, Xmax] graph limits (data units)
;	Yrng		[Ymin, Ymax] graph limits (data units)
;	Zrng		[Zmin, Zmax] graph limits (data units)
;COMMON aCURS3,
;	Xold		previous X-cursor value (for del-X computation)
;	Yold		previous Y-cursor value (for del-Y computation)
;	MainCurCol	color of cursor (NOT USED ??)
;	First_Plot	flag to indicate whether ax_color should be called
;	Last_Img	flag indicating last display on MainGraf was image (NOT USED ??)
;COMMON aCURS4,	delX, delY, delR, delZ, DXval, DYval, DRval, DZval, click1
;	delX		widget ID for delta-x value display
;	delY		widget ID for delta-y value display
;	delR		widget ID for delta-R value display (distance between points)
;	delZ		widget ID for delta-z value display (image intensity)
;	DXval		delta-x value
;	DYval		delta-y value
;	DRval		delta-R value
;	DZval		delta-z value
;	click1		0 - cursor free; 1 - first point selected; 2 - second point selected
;COMMON aprompt,
;	Uprompt		index for AXIS communication text window
;	version		version identifier (# (date))  					(10-may-98)
;   profl		profl=1 - extract profile                       (11-may-98)
;COMMON acolor,     ColTbl, bColor, UserR, UserG, UserB
;COMMON aSCALEBAR,  scale_bar, bar_pos
;	scale_bar	flag to plot or not plot bar
;	bar_pos		[bar_x, bar_y] position of start of bar in fraction of plot units
;COMMON aselect,
;	select_flag	flag to switch Thumbs from replot to select mode (28-sep-99)
;   copy_flag   flag to indicate copy operation
;	NewBuf		Number of new buffer
;   img_rep_line  flag to indicate mode to identify a replacement line
;	norm_flag	flag to control if ring current normalization is to be carried out (11-mar-07)
;COMMON axis_color_common,
;	ax_low_color_index, ax_top_color_index, $
;	ax_black_color_index, ax_white_color_index, $
;	ax_color00_index, ax_color01_index, ax_color02_index, ax_color03_index, $
;	ax_color04_index, ax_color05_index, ax_color06_index, ax_color07_index, $
;	ax_color08_index, ax_color09_index, ax_color10_index, ax_color11_index, $
;	ax_color12_index, ax_color13_index, ax_color14_index, ax_color15_index
;COMMON aLBL,       Label, BufLblFont
;	Label			array of 9 labels displayed with file list
;	BufLblFont		font used for widget (system specific !!)
;COMMON aOPTIONS, Mouse, Line_Sym, pan_smooth
;   Mouse		   	switch to indicate if Main_graph is active on mouse MOTION (=1) or click (=0)
;	Line_Sym		switch to determine if symbols are plotted (=1)
;	pan_smooth		switch to indicate if zoom graph updated on mouse MOTION (=1) or click (=0)
;   thumb_plot      switch to indicate that a ThumbZoom (4 or 9) is plotted (aph 10-jul-99)
;COMMON aparam,     (3-mar-98, 11-may-99)
;	X_calib  	X-slope, X-intercept for auto spectral scale setting
;	Y_calib     Y-slope, Y-intercept for auto spectral scale setting
;	constant	add/subtract constant
;	gain_m		multiplicative gain constant
;	gain_d		divisive gain constant
;	factor      constants for conversions
;	Xlock       standard (x1,x2) values (for image alignment)
;	Ylock       standard (y1,y2) values (for image alignment)
;	cll         (x,y) lower left of cutout (Zoom; align images)
;	cur  		(x,y) upper right of cutout (Zoom; align images)
;	pix_siz		size of pixel (for image aligmnment)
;COMMON lastpath,	(2-mar-98; 4-jan-00 overwrite_all)
;	lpath			last path accessed in pickfile routine
;	lfile			last file accessed in pickfile routine
;	overwrite_all	switch to indicate ignore overwrite checks in file writes
;COMMON alsRead,	(01-Jan-99)
;	I_process	procedure to massage I_file (none, dark, OSA, both)
;	Io_process	procedure to massage I_file (none, dark, OSA, both)
;	S_file		name of sample data file  (NB I_file used by stacks !!)
;	Io_file		name of reference data file
;	I_col		Column number for sample data
;	Io_col		Column number for reference data
;	als_readin	method of processing sample, ref (data, ratio, absorption)
;   Scan_Par_Update  switch to indicate updating paramaters during Browse
;COMMON ax_logo_com, (29-jan-00)
;	ax_logo		array of logo_num logo images
;	logo_rate	display rate
;	logo_num	number of images
;	logo_now 	current image
;	logo_size	size of image (gr_scale*360)
;   frontpanel	if = 1 then front panel (single or rotating) is up
;	logo_more	if = 1 continue displaying logo
;	logo_win	array of pixmap indices
;	logo_R		red color
;	logo_G
;	logo_B
; COMMON asfcom (25-nov-01)
;	sf_cmpd		formula
;	sf_emin		minimum energy
;	sf_emax		maximum energy
;	sf_mode		tpye of calculation (trans or mass abs)
;	sf_density	density
;	sf_thick	thickness
; COMMON tofcom  (14-feb-04)
;	tofE		photon energy
; 	stop1		stop # 1
;	stop2		stop # 2
;	bin_ns		bin size
;	tof1_min	minimum time for stop 1
;	tof1_max	maximum time for stop 1
;	tof2_min	minimum time for stop 2
;	tof2_max	maximum time for stop 2
; COMMON logtext  (14-sep-04)
;	log_last_line  index of last line in Widget_text box in panel
; COMMON MCF_EVENT, mcf  (26-Oct-04)  for multi-column ascii file read-in
;	MCF_ID		widget ID
;	MCF_Channel_List  list of channels
;	mcf_ext		current file extension
;	MCF_Xcol	column for X
;	MCF_Ycol	column for Y
;	MCF_rows	# of rows to skip
;	MCF_lasfile	name of last file
;	MCF_lastrow	last row
; COMMON aparam2   mesh_x, mesh_y, Io-val, nsmooth
;	mesh_x		#y-pixels to interpolate images to
;	mesh_y		#y-pixels to interpolate images to
;	Io_val		value of Io for converting images to OD
;	nsmooth		number of smooths (Savitsky-Golay or median)
; COMMON ansls,		(2-mar-98)
;   SD			ScanData - structure containing info of NSLS image scan
;				sd.wavelength - photon wavelength
;				sd.dwell - pixel dwell for images
;				sd.clock_frequency - something involved with count normalization
;
;
;MODIFICATION HISTORY:
; (16-Nov-99 aph) last addition
; (02-jan-00 aph) AXIS standard documentation
; (10-dec-00 cgz) added CurrentPath to COMMON aPATHS
; (25-NOV-01 APH) add asfcom
; (28-dec-01 aph) add pixelX, pixelY to COMMON aCurs1;
;				   frontpanel to ax_logo_com; img_rep_line to aselect
; (29-dec-01 aph) add aROTATE  ax_angle, ax_centre  ; alphabetized common blocks
; (31-dec-01 aph) add AxSpin to ADRAWID
; (16-feb-02 aph) add ascalebar
; (14-feb-04 aph) add tofcom
; (14-sep-04 aph) add log_text, log_last_line  (to use for storable log)
; (26-oct-04 aph) incorporate mcf_com
; (25-Feb-05 aph) add a_param2 - these ones are NOT set at start so must use
;                if n_Elements(parameter) EQ 0 then parameter = 'initial value'
; (23-Apr-05 aph) add nsmooth to a_param2
; (11-mar-07 aph) add flag for ring current normalization
;-
;
COMMON aBUF,       CurBuf, Data, pData, pNum, pBufs, BufStat, ButIDs, BufButs, OptButs
COMMON acolor,     ColTbl, bColor, UserR, UserG, UserB
COMMON axis_color_common, ax_low_color_index, ax_top_color_index, $
	ax_black_color_index, ax_white_color_index, $
	ax_image_bkgd_color_index, ax_image_axes_color_index, $
	ax_plot_bkgd_color_index, ax_plot_axes_color_index, ax_plot_color_index, $
	ax_color00_index, ax_color01_index, ax_color02_index, ax_color03_index, $
	ax_color04_index, ax_color05_index, ax_color06_index, ax_color07_index, $
	ax_color08_index, ax_color09_index, ax_color10_index, ax_color11_index, $
	ax_color12_index, ax_color13_index, ax_color14_index, ax_color15_index, $
	ax_color_def_names, ax_color_def_indices
COMMON aCURS1,	   CursorX, CursorY, CursorZ, pixelX, pixelY, xline, yline, Xval, Yval, Zval
COMMON aCURS2,	   GraphFrozen, CurFroz, CurX, CurY, Xrng, Yrng, Zrng
COMMON aCURS3,	   Xold, Yold, MainCurCol, First_Plot, Last_Img
COMMON aCURS4,	   delX, delY, delR, delZ, DXval, DYval, DRval, DZval, click1
COMMON aDRAWID,    Axis_Window, Axis_ID, MainWid, MainImg, XZPlot, YZPlot, ColorbarPlot,Thumbnail,AxSpin
COMMON aLBL,       Label, BufLblFont
COMMON alsRead,	   I_process, Io_process, S_file, Io_file, I_col, Io_col, als_readin, ScanPar_Update
COMMON aOPTIONS,   Mouse, Line_Sym, pan_smooth, thumb_plot
COMMON aparam,     X_calib, Y_calib, constant, gain_m, gain_d, factor, Xlock, Ylock, cll, cur, pix_siz
COMMON aPATHS,     DefPath, CurrentPath, WritePath, ini_file, codepath, last_image_ext, location
COMMON aPRINT,	   gr_dev, gr_scale, Print_dev, Pr_Command, print_file, Help_cmd, Net_command
COMMON aprompt,    Uprompt, axis_ver, profl
COMMON aROTATE,    ax_angle, ax_centre
COMMON aSCALEBAR,  scale_bar, bar_pos
COMMON aselect,	   select_flag, copy_flag, NewBuf, img_rep_line, norm_flag
COMMON asfcom,     sf_cmpd, sf_emin, sf_emax, sf_mode,sf_density,sf_thick
COMMON ax_logo_com, ax_logo, logo_rate, logo_num, logo_now, logo_size, frontpanel, logo_more, logo_win, logo_R, logo_G, logo_B
COMMON BufScal,	   Xscl,Yscl, Zscl, XXmin, XXmax, YYmin, YYmax, Zmin, Zmax, G_slider, G_lbl
COMMON lastpath,   lpath, lfile, overwrite_all
COMMON tofcom,	   tofE, stop1, stop2, bin_ns ,tof1_min,tof1_max, tof2_min, tof2_max
COMMON logtext,	   log_last_line
COMMON MCF_EVENT, mcf, MCF_ID, MCF_Channel_List, mcf_ext, $
      MCF_Xcol, MCF_Ycol, MCF_rows, MCF_lastfile, MCF_lastrow
COMMON aparam2,    mesh_x, mesh_y, Io_val, nsmooth
COMMON ansls,      SD
; KEEP the ansls line THE LAST !! - it is a structure of variable size
