;+
; This is the file SXM_FILEEXISTS
; It holds FUNCTION SXM_FILEEXISTS
; Returns 1 if the file exists, 0 otherwise.
; Need this because findfile() is broken on sxm at this moment...
;-

FUNCTION Sxm_fileexists, filename, nofindfile=nofindfile

IF keyword_set(nofindfile) THEN BEGIN
    get_lun, lun
    openr, lun, filename, error = code
    IF (code EQ 0) THEN BEGIN
        returnval = 1
    ENDIF ELSE BEGIN
        returnval = 0
    ENDELSE
    close, lun
    free_lun, lun
ENDIF ELSE BEGIN
    temp = findfile(filename)
    svec = size(temp)
    IF (svec(0) EQ 0) THEN BEGIN
        ; Got a single null string, so file does not exist
        returnval = 0
    ENDIF ELSE BEGIN
        returnval = 1
    ENDELSE
ENDELSE

return, returnval
END

