;+
; pro read_csv,filename,x,y
;
;   Extracts the data from comma space value files like are used in Excel
;
;   Inputs
;   filename    the name of the mapper file to be read
;
;   Outputs
;   x   an array containing the x values from the file
;   y   an array containing the y values from the file.
;               this could be multidimensional...
;
;   Usage
;   read_csv, filename, x, y
;;
;   Completely rewritten Nov. 1997, CJJ
;   CJJ, July 24, 1998: skip lines which start with anything other than
;     space, tab, or a number or a plus sign or a minus sign or a decimal point
;-

; This routine strips out the first stuff before a comma
FUNCTION Read_csv_firstnum, input_string, firstnum_string

IF (strlen(input_string) EQ 0) THEN BEGIN
    firstnum_string = ''
    return,0
ENDIF

comma_pos = strpos(input_string,',')
IF (comma_pos EQ (-1)) THEN BEGIN
    firstnum_string = input_string
    input_string = ''
ENDIF ELSE BEGIN
    firstnum_string = strmid(input_string,0,comma_pos)
    length = strlen(input_string)-comma_pos-1
    input_string = strmid(input_string,comma_pos+1,length)
ENDELSE

return,1
END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO Read_csv, filename, items, help=help, quiet=quiet

IF (keyword_set(help) OR (n_elements(filename) EQ 0) OR $
    (n_params() EQ 0)) THEN BEGIN
    print, 'read_csv,filename,items [/quiet]'
    print, '  Reads in data as strings (like from Excel .CSV files)'
    return
ENDIF

filelist = findfile(filename)
svec = size(filelist)
IF (svec(0) EQ 0) THEN BEGIN
    print,'Could not open file "'+filename+'"'
    return
ENDIF

on_ioerror,bailout
get_lun,lun
openr, lun, filename

;  Data for plotting in Mapper files is usually proceded by the PLOTIT
;  commmand.  To find the data, search for this command.
input_string = ""
got_firstline = 0
items_per_line = 0
zero_byte = byte('0')
nine_byte = byte('9')
point_byte = byte('.')
plus_byte = byte('+')
minus_byte = byte('-')
space_byte = byte(' ')
tab_byte = byte(9)

WHILE (NOT EOF(lun)) DO BEGIN
    readf, lun, input_string

    firstchar = strmid(input_string,0,1)
    IF ((firstchar EQ space_byte) OR (firstchar EQ tab_byte) OR $
        (firstchar EQ plus_byte) OR (firstchar EQ minus_byte) OR $
        (firstchar EQ point_byte) OR $
        ((firstchar GE zero_byte) AND (firstchar LE nine_byte)) ) THEN BEGIN

        IF (got_firstline EQ 0) THEN BEGIN
            IF (read_csv_firstnum(input_string,item) EQ 0) THEN BEGIN
                goto,bailout
            ENDIF
            items = [item]
            WHILE (read_csv_firstnum(input_string,item) NE 0) DO BEGIN
                items = [items,item]
            ENDWHILE
            items_per_line = n_elements(items)
            items = reform(items,1,items_per_line)
            got_firstline = 1
        ENDIF ELSE BEGIN
            IF (read_csv_firstnum(input_string,item) EQ 0) THEN BEGIN
                goto,bailout
            ENDIF
            temp_items = [item]
            WHILE (read_csv_firstnum(input_string,item) NE 0) DO BEGIN
                temp_items = [temp_items,item]
            ENDWHILE
            n_temp = n_elements(temp_items)
            this_items = strarr(1,items_per_line)
            this_items(0,0:(n_temp-1)) = temp_items(0:(n_temp-1))
            items = [items,this_items]
        ENDELSE
    ENDIF
ENDWHILE

bailout:
close,lun
free_lun,lun

return
END


