; Adam Hitchcock (@1999) 
;+ 
; FILE 
;		  ZIMBA_RUN.PRO 
; 
; LAST CHANGED: ---------------------- 18-jan-00 
; 
; PURPOSE 
;   execute Zstack_analyze to align stack data (nc format) and extract spectra 
;   with provision for loading from file (*.sl), with an alignment file 
; 
; KEYWORDS 
;	AXIS - if set, indicates AXIS widget exists and the user prompt dialog is used 
; 
; COMMON 
;   @axis_com - common block for AXIS 
; 
; MODIFICATIONS 
; (26-sep-99 aph) first version (simplifying axis_c) 
; (18-jan-00 aph) adapt to new zstack code (Jan-00) 
;- 
 
PRO ZIMBA_RUN, axis=axis 
 
@axis_com 
on_error,2 
 
	if  keyword_set(AXIS) THEN BEGIN 
		WIDGET_CONTROL, Uprompt, Bad_ID = BadID, SET_VALUE= 'Select file-list file' 
	endif else Print, 'Select file-list file' 
	scan_file = dialog_pickfile(/READ, FILTER='*.sl',PATH = DefPath, GET_PATH =LPATH) 
	DefPath = Lpath & Write_path = Lpath 
	if strlen(scan_file) GT 0 THEN BEGIN  ; bail-out if no filename 
	; ------ read in the *.sl file here and rewrite if needed 
		test = stack_list(scan_file) 
		if test EQ 0 then return		; BAIL if no valid SL file 
		if  keyword_set(AXIS) THEN BEGIN 
			WIDGET_CONTROL, Uprompt, Bad_ID = BadID, SET_VALUE= 'Select alignment data file' 
		endif else Print, 'Select alignment data file' 
		align_file = dialog_pickfile(/READ, FILTER='*.aln', PATH = DefPath, GET_PATH =LPATH) 
		zoom_num= 1 
		if strlen(align_file) GT 0 THEN BEGIN  ; bail-out if no filename 
			Zstack_analyze, scan_file, align_file  ;,zoom=zoom_num 
		endif else Zstack_analyze, scan_file ;, zoom=zoom_num 
	endif else Zstack_analyze 
 
END