function read_BNL, file, header_only=header_only, _extra=e 
 
;+ 
; FUNCTION  READ_BNL, file, sd 
; ---------------------------------- last changed: 20-may-00 ----------- 
; Reads in an NSLS STXM image from netCDF format. 
; 
; It puts the image and associated information into BSIF_COMMON variables: 
;   image_data (the image array - possibly several planes deep for I, IO, CLOCK) 
;   x_normal, y_normal, rotated, x_title, y_title, 
;   x_dist, and y_dist 
; 
; The STXM scan data is put into "sd" 
; Based on Mark Rivers stuff; Chris Jacobsen, June 1993 
 
; ------------ Development history -------------------- 
; ( 7 -aug-97 aph)  - added type='2d' 
; (27-May-97 aph) - adapted from nsls version of READ_STXM 
;                    to put data into ALS-style STRUCTURE 
; ( 8-Mar-98 aph) - add SD to recover and use photon energy; use AXIS common 
; (18-apr-98 aph) - SGU reported bug re divide by timer FIXED 
; ( 6-Jun-98 aph)  - made xl label identical to that in read_als() 
; (14-jun-98 aph) - axis_com 
; (19-jun-98 aph) - normalise to average time so counts ~ right 
; (29-jun-98 aph) - correct problem with "skew,kurtosis not defined for var=0" 
; (28-jul-98 aph) - dwell format 
; (25-jun-99 aph) - use ax_name to parse filename 
; (01-apr-00 aph) - extend size of E-display format 
; (20-may-00 aph) - do not prompt for name if filename given 
;- 
on_error,2 
@axis_com
@bsif_com
 
if n_elements(file) eq 0 then begin  ;popup file dialog box 
   fltr='*.nc' 
   if keyword_set(nof) then fltr='*' 
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath) 
endif 
 
if strlen(file) GT 0 THEN BEGIN  ; bail-out if no filename 
 
; Open the file to be read 
cdfid = ncdf_open(file, /NOWRITE) 
 
ncdf_diminq, cdfid, 0, dummy, n_cols 
ncdf_diminq, cdfid, 1, dummy, n_rows 
ncdf_diminq, cdfid, 2, dummy, n_data 
ncdf_diminq, cdfid, 3, dummy, n_chars 
 
image_data_id = ncdf_varid(cdfid, 'image_data') 
data_title_id = ncdf_varid(cdfid, 'data_title') 
 
 
; Retrieve global attributes 
ncdf_attget, cdfid, /GLOBAL, "title", image_title 
 
; Retrieve BSIF information 
ncdf_attget, cdfid, image_data_id, "x_normal", x_normal 
ncdf_attget, cdfid, image_data_id, "y_normal", y_normal 
ncdf_attget, cdfid, image_data_id, "rotated", rotated 
ncdf_attget, cdfid, image_data_id, "x_start", x_start 
ncdf_attget, cdfid, image_data_id, "x_stop", x_stop 
ncdf_attget, cdfid, image_data_id, "y_start", y_start 
ncdf_attget, cdfid, image_data_id, "y_stop", y_stop 
ncdf_attget, cdfid, image_data_id, "x_title", x_title 
ncdf_attget, cdfid, image_data_id, "y_title", y_title 
 
init_sd,sd 
ncdf_attget, cdfid, image_data_id, "version_number", t 
sd.version_number=t 
ncdf_attget, cdfid, image_data_id, "scan_driver_mode", t 
sd.scan_driver_mode=t 
ncdf_attget, cdfid, image_data_id, "scan_width", t 
sd.scan_width=t 
ncdf_attget, cdfid, image_data_id, "scan_height", t 
sd.scan_height=t 
ncdf_attget, cdfid, image_data_id, "i0_mode", t 
sd.i0_mode=t 
ncdf_attget, cdfid, image_data_id, "clock_frequency", t 
sd.clock_frequency=t 
ncdf_attget, cdfid, image_data_id, "sd_x_start", t 
sd.x_start=t 
ncdf_attget, cdfid, image_data_id, "sd_x_stop", t 
sd.x_stop=t 
ncdf_attget, cdfid, image_data_id, "x_center", t 
sd.x_center=t 
ncdf_attget, cdfid, image_data_id, "x_step_size", t 
sd.x_step_size=t 
ncdf_attget, cdfid, image_data_id, "sd_y_start", t 
sd.y_start=t 
ncdf_attget, cdfid, image_data_id, "sd_y_stop", t 
sd.y_stop=t 
ncdf_attget, cdfid, image_data_id, "y_center", t 
sd.y_center=t 
ncdf_attget, cdfid, image_data_id, "y_step_size", t 
sd.y_step_size=t 
ncdf_attget, cdfid, image_data_id, "z_start", t 
sd.z_start=t 
ncdf_attget, cdfid, image_data_id, "z_stop", t 
sd.z_stop=t 
ncdf_attget, cdfid, image_data_id, "z_center", t 
sd.z_center=t 
ncdf_attget, cdfid, image_data_id, "z_step_size", t 
sd.z_step_size=t 
ncdf_attget, cdfid, image_data_id, "focus_position", t 
sd.focus_position=t 
ncdf_attget, cdfid, image_data_id, "dwell_time", t 
sd.dwell_time=t 
ncdf_attget, cdfid, image_data_id, "x_prescan_distance", t 
sd.x_prescan_distance=t 
ncdf_attget, cdfid, image_data_id, "y_prescan_distance", t 
sd.y_prescan_distance=t 
ncdf_attget, cdfid, image_data_id, "x_postscan_distance", t 
sd.x_postscan_distance=t 
ncdf_attget, cdfid, image_data_id, "x_postscan_distance", t 
sd.x_postscan_distance=t 
ncdf_attget, cdfid, image_data_id, "flyback_velocity", t 
sd.flyback_velocity=t 
ncdf_attget, cdfid, image_data_id, "entrance_slit", t 
sd.entrance_slit=t 
ncdf_attget, cdfid, image_data_id, "exit_slit", t 
sd.exit_slit=t 
ncdf_attget, cdfid, image_data_id, "wavelength", t 
sd.wavelength=t 
ncdf_attget, cdfid, image_data_id, "date_time", t 
sd.date_time=byte(string(t)) 
;ncdf_attget, cdfid, image_data_id, "sd.operator", t 
;sd.operator=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "sample", t 
sd.sample=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "zone_plate", t 
sd.zone_plate=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "comment1", t 
sd.comment1=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "comment2", t 
sd.comment2=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "file_name", t 
sd.file_name=byte(string(t)) 
ncdf_attget, cdfid, image_data_id, "ring_current", t 
sd.ring_current=t 
ncdf_attget, cdfid, image_data_id, "undulator_gap", t 
sd.undulator_gap=t 
ncdf_attget, cdfid, image_data_id, "idling_time", t 
sd.idling_time=t 
ncdf_attget, cdfid, image_data_id, "auto_shutter", t 
sd.auto_shutter=t 
ncdf_attget, cdfid, image_data_id, "x_pzt_offset", t 
sd.x_pzt_offset=t 
ncdf_attget, cdfid, image_data_id, "y_pzt_offset", t 
sd.y_pzt_offset=t 
ncdf_attget, cdfid, image_data_id, "initial_lambda", t 
sd.initial_lambda=t 
ncdf_attget, cdfid, image_data_id, "final_lambda", t 
sd.final_lambda=t 
ncdf_attget, cdfid, image_data_id, "sgm_step_size", t 
sd.sgm_step_size=t 
ncdf_attget, cdfid, image_data_id, "dx_dl", t 
sd.dx_dl=t 
ncdf_attget, cdfid, image_data_id, "dy_dl", t 
sd.dy_dl=t 
ncdf_attget, cdfid, image_data_id, "dz_de", t 
sd.dz_de=t 
 
sd_len=n_tags(sd,/length) 
user_buffer=bytarr(sd_len) 
;copy_bytes,sd_len,sd,user_buffer      ; this causes IDL to write - nogo in demo mode 
 
if (not keyword_set(header_only)) then begin 
  ncdf_varget, cdfid, image_data_id, image_data 
endif 
ncdf_varget, cdfid, data_title_id, data_title 
 
;calculate x_dist for spectra 
x_pixel_size = (x_stop - x_start)/n_cols 
y_pixel_size = (y_stop - y_start)/n_rows 
x_dist = x_start + (findgen(n_cols) * x_pixel_size) 
 
 
ncdf_close, cdfid 
;help, image_data 
 
;  Add-in to generate structure to parallel the ALS format (aph) 
	Nsize = size(image_data) 
	x = findgen(N_cols) 
	y = findgen(N_rows) 
; if clock data is identical - this does not work !! 
	mom = median(image_data(*,*,1)) 
 
	FOR i = 0, N_cols-1 DO x(i) = (i* x_pixel_size) 
 	FOR i = 0, N_rows-1 DO y(i) = (i* y_pixel_size) 
	d=float(image_data(*,*,0))*mom(0)/float(image_data(*,*,1))        ; time normalize 
 
;	print, 'image_data: ',image_data_id 
;	print, 'data_title: ',data_title_id 
;	delta_X = N_cols * x_pixel_size 
;	delta_Y = N_rows * x_pixel_size 
;	print, N_cols, ' x ', N_rows,' pixels. ' 
;	print,   delta_X, ' x ', delta_Y, ' um' 
 
	name_bits = ax_name(file) 
	dl = name_bits(1) 
	type='2d' 
	if sd.wavelength EQ 0. then sd.wavelength = 12398. 
	energy = 12398./sd.wavelength 
	xl = string(FORMAT='("x (um)     E = ",f8.3," eV     dwell = ",f7.2," ms")', $ 
      energy, sd.dwell_time) 
	tmp = {t:type, x:x, y:y, d:d, e: energy, xl:xl, yl:'nsls   y (um)', dl:dl}  ; *** ADD Energy to format 
 
	print, 'read NSLS image from file: ', file 
	print, format='(i4," x ",i4," pts. ",f7.4," x ",f7.4," um pixels.  E= ",f8.3, " eV.  Dwell= ",f7.2," ms.")', $ 
	    n_cols,n_rows,x_pixel_size, y_pixel_size, energy, sd.dwell_time 
 
endif else begin 	; go here if user pushes 'cancel' 
    print, ' file name of zero length. Read aborted' 
    tmp=0 
endelse 
return, tmp 
end 
 
