; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	RD_SPEM.PRO 
; 
;LAST CHANGED: ----------------------------------- 30-nov-00 
; 
;PURPOSE: 
;	This reads SPEM data from a XPD labview format data file  
; 
;CATEGORY: 
;	STAND ALONE: utilities 
; 
;CALLING SEQUENCE: 
;	Result = RD_SPEM(FILE) 
; 
;INPUTS:
;	FILE - SPEM data file
; 
;KEYWORD PARAMETERS: 
;	NOFILTER - 
;	_EXTRA -
;
;CALLED FROM AXIS: 
;	many procedures 
; 
;ROUTINES 
;	function LOADSPEM, fname, PK=pknum, NORM=normnum, AVG=avgnum, $ 
;                  PLOT=pl, GLITCH=ngli, SDEV=nsdev, QUIET=quiet 
; 		Copyright (c) 1998, ALS SpectroMicroscopy Facility, jd 
;    - read SPEM image(s) from XPD labview data file format 
;    Options: 
;       /PLOT - display (splot2d) image (first image if multiple) 
;       /GLITCH - run manual glitch threshold window 
;       SDEV=n - run auto glitch filter for data outside n std deviations 
; 
;	function Rd_SPEM, file, NOFILTER=nof, _extra=e 
;    Options: 
;	NOFILTER - 
;	_EXTRA -
; 
; COMMON BLOCKS: 
;   @AXIS_COM - set of common blocks for AXIS 
; 
;MODIFICATION HISTORY: 
; adapted to put a file picker around LOADSPEM 
; (31-Jan-00 aph) add hourglass since slow 
; (15-nov-00 cgz) AXIS standard documentation 
; (15-nov-00 cgz) migrated LOADSPEM.PRO function into RD_SPEM.PRO
;				since LOADSPEM is only called from within RD_SPEM.PRO
; (15-nov-00 cgz) Replaced call of DIMEN function by explicit (SIZE(var))(index+1) in LOADSPEM
; (30-nov-00 cgz) Replaced call of nwin with explicit window statement
;- 
; ******************************************************************************* 

 
function loadspem, fname, PK=pknum, NORM=normnum, AVG=avgnum, $ 
                  PLOT=pl, GLITCH=ngli, SDEV=nsdev, QUIET=quiet 

; 	Copyright (c) 1998, ALS SpectroMicroscopy Facility, jd 
; ------------------------- last changed: 12-May-99 
; ------------------------ from ALS 7-May-99 version 

on_error,2 
@axis_com
  ;if (keyword_set(fname) eq 0) then fname=pickfile2() 
 
if not keyword_set(quiet) then quiet=0 
f=gen_read(fname, Q=quiet) 
fileshort=strmid(f.fname,strlen(f.fname)-9, strlen(f.fname)) 
 
xx=reform(f.indvars(0,*)) 
;ncol=dimen(f.indvars,1) 
ncol=(size(f.indvars))(2) 
 
;determine repeat in 1st column  (slow loop) 
xx0=xx(0) 
nx=1 
for i=1,ncol-1 do begin 
   if (xx(i) eq xx0) then begin 
      nx=i 
      goto, break 
   endif 
endfor 
 
break: 
ny=floor(ncol/nx) 
nc=nx*ny 
;nd=dimen(f.singledata,0) 
nd=(size(f.singledata))(1) 
print, ncol, nc, nx, 'x', ny, ': nd=', nd 
 
xaxis=xx(0:nx-1) 
yy=reform(transpose(reform(f.indvars(1,0:nc-1),nx, ny))) 
yaxis=yy(0:ny-1) 
 
;image(s) 
;if n_elements(pknum) eq 0 then pknum=0 
if n_elements(avgnum) gt 1 then begin   ;average over indices in array 
   navg=n_elements(avgnum) 
   print, 'Avg Peak over ', navg, ' indices' 
   img=fltarr(nx, ny) 
   for i=0,navg-1 do img=img+reform(f.singledata(avgnum(i),0:nc-1),nx, ny) 
   img=img/navg 
   npk=1 
endif else begin 
   if n_elements(pknum) ge 1 then begin   ;peak number(s) specified 
      npk=n_elements(pknum) 
      img=fltarr(nx, ny, npk) 
      for i=0,npk-1 do img(*,*,i)=reform(f.singledata(pknum(i),0:nc-1),nx, ny) 
   endif else begin           ;get all images 
      npk=f.summary[4]    ;or n_elements( f.singlenames ) 
      img=fltarr(nx, ny, npk) 
      for i=0,npk-1 do img(*,*,i)=reform(f.singledata(i,0:nc-1),nx, ny) 
   endelse 
   img=reform(img) 
endelse 
 
;  s={d:dat, x:xx, y:yy, xl:f.indnames(0), yl:f.indnames(1), dl:fileshort} 
;print, keyword_set(norm), n_elements(norm) 
norm=0 
if n_elements(normnum) gt 0 then begin 
	norm=1 
	if n_elements(normnum) gt 1 then begin 
	   ;average over indices in array 
	   nnorm=n_elements(normnum) 
	   print, 'Avg Norm over ', npk, ' indices' 
	   nrm=fltarr(nx, ny) 
	   for i=0,nnorm-1 do nrm=nrm+reform(f.singledata(normnum(i),0:nc-1),nx, ny) 
	   nrm=nrm/nnorm 
	endif else begin 
	   normnum=max([min([normnum,nd-1]),0]) 
	   nrm=reform(f.singledata(normnum,0:nc-1),nx, ny) 
	endelse 
endif 
 
if (npk gt 1) then begin 
   if norm then $ 
      s={d:img, dn:nrm, x:xaxis, y:yaxis, z:indgen(npk), xl:'x (um)', yl:'y (um)', zl:'BE', sl:fileshort, dl:''} $ 
   else $ 
      s={d:img, x:xaxis, y:yaxis, z:indgen(npk), xl:'x (um)', yl:'y (um)', zl:'BE', sl:fileshort, dl:''} 
 
endif else begin 
   if norm then $ 
      s={d:img, dn:nrm, x:xaxis, y:yaxis, xl:'x (um)', yl:'y (um)',sl:fileshort, dl:''} $ 
   else $ 
      s={d:img, x:xaxis, y:yaxis, xl:'x (um)', yl:'y (um)', sl:fileshort, dl:''} 
endelse 
 
;  if keyword_set(pknum) eq 0 then pknum=0 
;;  if keyword_set(nps) eq 0 then nps=max([dimen(xx,0),dimen(yy,0)]) 
;  if keyword_set(nps) eq 0 then nps=max([(size(xx))(1),(size(yy))(1)]) 
;  if keyword_set(nm) then $ 
;    zz=reform(f.singledata(pknum,*)/f.norm1dim(pknum,*)) $ 
;  else $ 
;    zz=reform(f.singledata(pknum,*)) 
;  triangulate,xx,yy,tri 
;  ans={d:trigrid(xx,yy,zz,tri,abs([(min(xx)-max(xx))/(nps-1), (min(yy)-max(yy))/(nps-1)])),$ 
;       x:xx, y:yy, xl:f.indnames(0), yl:f.indnames(1)} 
 
if keyword_set(ngli) then GLITCH, s, ngli 
if keyword_set(nsdev) then GLITCH, s, SDEV=nsdev 
 
if keyword_set(pl) then begin 
   log=0 
   if pl eq 2 then log=1 
;   if !d.window eq -1 or !d.window gt 31 then nwin, 0 
   if !d.window eq -1 or !d.window gt 31 then window, 0, xsize=300, ysize=300 
;   if !d.window eq 20 and keyword_set(ngli) then nwin		; 20=glitch filter window 
   if !d.window eq 20 and keyword_set(ngli) then window, !d.window+1<0, xsize=300, ysize=300		; 20=glitch filter window 
		; cgz - don't think there is any possibility that !d.window+1 could be less than zero
		;		i.e., no window can ever be anything other than -1, 0, 1, 2, ...
   splot2d, s, NORM=norm, LOG=log, _extra=e, charsize=1 
endif 
return, s 
end 

; *************************

function Rd_SPEM, file, NOFILTER=nof, _extra=e 
 
; ------------------- last changed 31-Jan-00 
; adapted to put a file picker around LOADSPEM 
; MODIFICATIONS 
; (31-Jan-00 aph) add hourglass since slow 
 
 
on_error,2 
@axis_com
 
if n_elements(file) eq 0 then begin  ;popup file dialog box 
   fltr='*.*' 
   if keyword_set(nof) then fltr='*' 
   file=PICKFILE2(/Read, FILTER=fltr, /LPATH, DEFPATH=defpath) 
endif 
s = 0 
IF strlen(file) GT 0 THEN BEGIN 
	pk = 0 
	if widget_info(/active) EQ 1 then begin 
		pk = get_num(VAL = pk, prompt = 'Peak #', group = axis_id) 
		widget_control, /hourglass 
	endif else pk = get_num(VAL = pk, prompt = 'Peak #') 
	a = loadspem(file,pk=pk) 
	; check for NaN values - truncate to exclude these 
	test = where(finite(a.y) EQ 1) 
	if n_elements(test) LT n_elements(a.y) then begin 
		print, 'WARNING: data contains NaN values - removing them' 
		ydim = n_elements(test)-2 
		d = a.d(*,0:ydim) 
		y = a.y(0:ydim) 
		a.xl = a.xl +'   Ch# ' + strcompress(string(fix(pk))) 
		a={x: a.x, y: y, d: d, xl: a.xl, yl: a.yl, sl: a.sl, dl: a.dl} 
		print, 'Image truncated to ', fix(n_elements(a.x)), ' x ', fix(n_elements(a.y)) 
	endif 
	s = {t:'2d', x: a.x, y: a.y, d: 1000.*a.d, xl: a.xl, yl: 'als-SPEM   ' + a.yl, dl: a.sl} 
ENDIF 
 
return, s 
end 
 
