; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	AXIS_OPTIONS_EVENTCB 
; 
;LAST CHANGED: ----------------------------------- 31-jan-00 
; 
;PURPOSE: 
;	This set of procedures are the event processing for the AXIS_OPTIONS widget. 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;ROUTINES 
; AXIS_Opts_Update - loads current default values into AXIS_OPTIONS widget 
; BUT_Update, Event - takes info from the AXIS_OPTIONS widget 
;                     and writes the ini file 
;	BUT_Cancel	- cancel 
;	BUT_WIN		BUT_X		BUT_OpSys_Other	TXT_Set_Op_Sys - op. system 
;	BUT_PS	BUT_PCL		BUT_Print_Other		TXT_Set_Print_device - printer 
;	BUT_Mac	BUT_ALS	BUT_NSLS	BUT_Location_Other	TXT_Set_Location - location 
;	BUT_Size_050	BUT_Size_075	BUT_Size_100	BUT_Size_125 
;	BUT_Size_150	- size of AXIS 
;	Zero_buts	- sets exclusive buttons to zero on starting widget 
;	Load_def_Win	- loads default parameters for Windows systems 
;	Load_Def_X		- loads default parameters for unix systems 
;	BUT_INI_Browse	BUT_SOURCE_Browse	BUT_DATA_Browse	BUT_Print_Browse 
;	browse for file names 
;	axis_options_eventcb - auto loading stub 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;PROCEDURE: 
; 	works with AXIS_OPTIONS.PRO Widget to establish AXIS defaults 
; 
;MODIFICATION HISTORY: 
; Generated on:	12/28/98 21:13.49 
; (aph 29-Dec-98) first written using new IDL 5.2 GUIBuilder (aph^2) 
; (aph 03-Jan-99) set Windows default font to Arial*14 
; (aph 24-May-99) revise to display/modify Pr_command (replace print_file) 
; (16-nov-99 aph) change 'loc' to 'location' (for place specific features) 
; (03-jan-00 aph) AXIS standard documentation 
; (31-jan-00 aph) add Web browser command; re-arrange 
;- 
; 
; 
;----------------------------------------------------------------- 
; Kill Notify Callback Procedure. 
; Argument: 
;   wWidget - ID number of specific widget. 
; 
; 
;   Retrieve the IDs of other widgets in the widget hierarchy using 
;       id=widget_info(Event.top, FIND_BY_UNAME=name) 
 
;----------------------------------------------------------------- 
;----------------------------------------------------------------- 
; Activate Button Callback Procedure. 
; Argument: 
;   wWidget - ID number of specific widget. 
; 
;   SELECT is set to 1 if the button was set, and 0 if released. 
;       Normal buttons do not generate events when released, so 
;       SELECT will always be 1. However, toggle buttons (created by 
;       parenting a button to an exclusive or non-exclusive base) 
;       return separate events for the set and release actions. 
 
;   Retrieve the IDs of other widgets in the widget hierarchy using 
;       id=widget_info(Event.top, FIND_BY_UNAME=name) 
 
; **************************************************************** 
 
pro AXIS_Opts_Update, wWidget 
@axis_com
 
	PRINT, 'Loading current values' 
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Ini_File') 
   	WIDGET_CONTROL,id, Set_value = ini_file 
   	print, 'ini_file = ', ini_file 
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Source_Path') 
   	WIDGET_CONTROL,id, Set_value = CodePath 
   	print, 'CodePath = ', CodePath 
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Data_Path') 
   	WIDGET_CONTROL,id, Set_value = DefPath 
   	print, 'DefPath = ', DefPath 
  	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Color_Table') 
   	WIDGET_CONTROL,id, Set_value = strcompress(string(ColTbl)) 
   	print, 'Color table = ', strcompress(string(ColTbl)) 
  	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Font') 
   	WIDGET_CONTROL,id, Set_value = BufLblFont 
   	print, 'BufLblFont = ', BufLblFont 
  	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Print_command') 
   	WIDGET_CONTROL,id, Set_value = Pr_command 
   	print, 'Print command = ', Pr_command 
  	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Help_cmd') 
   	WIDGET_CONTROL,id, Set_value = Help_cmd 
   	print, 'Help command = ', Help_cmd 
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Web_cmd') 
   	WIDGET_CONTROL,id, Set_value = Net_command 
   	print, 'Net browser command = ', Net_command 
 
; ---------- exclusive button boxes 
; ------- Op_Sys -------- 
CASE gr_dev OF 
'WIN': BEGIN 
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_WIN') 
	WIDGET_CONTROL,id, Set_Button = 1 
END 
'X': BEGIN 
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_X') 
	WIDGET_CONTROL,id, Set_Button = 1 
END 
ELSE: BEGIN 
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_OpSys_Other') 
	WIDGET_CONTROL,id, Set_Button = 1 
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Set_Op_Sys') 
   	WIDGET_CONTROL,id, Sensitive=1, Set_Value = gr_dev 
ENDELSE 
ENDCASE 
 
; ------- Print_Device  -------- 
CASE Print_dev OF 
'PS': BEGIN 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_PS') 
   WIDGET_CONTROL,id, Set_Button = 1 
END 
'PCL': BEGIN 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_PCL') 
   WIDGET_CONTROL,id, Set_Button = 1 
END 
ELSE: BEGIN 
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Print_Other') 
	WIDGET_CONTROL,id, Set_Button = 1 
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Set_Print_Device') 
   	WIDGET_CONTROL,id, Sensitive=1, Set_Value = Print_dev 
ENDELSE 
ENDCASE 
 
; ------- Location -------- 
CASE location OF 
'mac': BEGIN 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Mac') 
   WIDGET_CONTROL,id, Set_Button = 1 
END 
'ALS': BEGIN 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_ALS') 
   WIDGET_CONTROL,id, Set_Button = 1 
END 
'NSLS': BEGIN 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_NSLS') 
   WIDGET_CONTROL,id, Set_Button = 1 
END 
ELSE: BEGIN 
	id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Location_Other') 
	WIDGET_CONTROL,id, Set_Button = 1 
   	id = widget_info(wWidget, FIND_BY_UNAME = 'TXT_Set_Location') 
   	WIDGET_CONTROL,id, Sensitive=1, Set_Value = location 
ENDELSE 
ENDCASE 
 
; ------- Size (force to one of 4) -------- 
ax_size = float(gr_scale) 
if ax_size LE 0.85 then BEGIN 
   gr_scale=0.75 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Size_075') 
   WIDGET_CONTROL,id, Set_Button = 1 
ENDIF 
if ax_size GT 0.85 AND ax_size LE 1.10 then BEGIN 
   gr_scale=1.00 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Size_100') 
   WIDGET_CONTROL,id, Set_Button = 1 
ENDIF 
if ax_size GT 1.10 AND ax_size LE 1.35 then BEGIN 
   gr_scale=1.25 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Size_125') 
   WIDGET_CONTROL,id, Set_Button = 1 
ENDIF 
if ax_size GT 1.35 then BEGIN 
   gr_scale=1.50 
   id = widget_info(wWidget, FIND_BY_UNAME = 'BUT_Size_150') 
   WIDGET_CONTROL,id, Set_Button = 1 
ENDIF 
 
END 
 
pro BUT_Update, Event 
; -------------------  last changed: 29-Dec-98 
; takes info from the AXIS_OPTIONS widget and writes the ini file 
 
@axis_com
 
; -------- get the values of the files, paths etc 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Ini_File') 
   	WIDGET_CONTROL,id, Get_value = test & ini_file = test(0) 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Source_Path') 
   	WIDGET_CONTROL,id, Get_value = test & CodePath = test(0) 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Data_Path') 
   	WIDGET_CONTROL,id, Get_value = test & DefPath = test(0) 
  	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Color_Table') 
   	WIDGET_CONTROL,id, Get_value = test & ColTbl = fix(test(0)) 
  	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Font') 
   	WIDGET_CONTROL,id, Get_value = test & BufLblFont = test(0) 
	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Print_command') 
   	WIDGET_CONTROL,id, Get_value = test & Pr_command = test(0) 
	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Help_cmd') 
   	WIDGET_CONTROL,id, Get_value = test & Help_cmd = test(0) 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Web_cmd') 
   	WIDGET_CONTROL,id, Get_value = test & Net_command = test(0) 
 
; ------------ store these in new (default) *.ini file -------------------- 
 
	axis_ini_save	; use the version in axis-ini.pro to standardize the contents of AXIS.INI 
 
   	WIDGET_CONTROL, Event.Top, /DESTROY 
	return 
 
bad_ini_file: 
	print, 'Error on writing AXIS default parameter file. Check values' 
	return 
end 
 
pro BUT_Cancel, Event 
; ----------------------------- last changed:  28-Dec-98 
   	 WIDGET_CONTROL, Event.Top, /DESTROY 
end 
 
; ***********************  Operating System ********************** 
;----------------------------------------------------------------- 
 
pro BUT_WIN, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Op_Sys') 
   	WIDGET_CONTROL,id, Sensitive=0 
	gr_dev = 'WIN' 
	print, 'Operating System set to ', gr_dev 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_X, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Op_Sys') 
   	WIDGET_CONTROL,id, Sensitive=0 
	gr_dev = 'X' 
	print, 'Operating System set to ', gr_dev 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_OpSys_Other, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Op_Sys') 
   	WIDGET_CONTROL,id, Sensitive=1, Get_value = test 
   	gr_dev = test(0) 
	print, 'Operating System set to Other: ', gr_dev 
end 
 
PRO TXT_Set_Op_Sys, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Op_Sys') 
   	WIDGET_CONTROL,id, Sensitive=1, Get_value = test 
   	gr_Dev = test(0) 
	print, 'Operating System set to ', gr_dev 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_PS, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Print_device') 
   	WIDGET_CONTROL,id, Sensitive=0 
	Print_Dev = 'PS' 
	print, 'Print Device set to ', Print_Dev 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_PCL, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Print_device') 
   	WIDGET_CONTROL,id, Sensitive=0 
	Print_Dev = 'PCL' 
	print, 'Print Device set to ', Print_Dev 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_Print_Other, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Print_device') 
   	WIDGET_CONTROL,id, Sensitive=1, Get_value = test 
   	Print_Dev = test(0) 
	print, 'Print Device set to Other: ', Print_Dev 
end 
 
PRO TXT_Set_Print_device, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Print_device') 
   	WIDGET_CONTROL,id, Sensitive=1, Get_value = test 
   	Print_Dev = test(0) 
	print, 'Print Device set to ', Print_Dev 
end 
 
; ******************  BASE_Location ****************************** 
;----------------------------------------------------------------- 
 
pro BUT_Mac, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Location') 
   	WIDGET_CONTROL,id, Sensitive=0 
	location = 'Mac' 
	print, 'Location set to ', location 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_ALS, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Location') 
   	WIDGET_CONTROL,id, Sensitive=0 
	location = 'ALS' 
	print, 'Location set to ', location 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
pro BUT_NSLS, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Location') 
   	WIDGET_CONTROL,id, Sensitive=0 
	location = 'NSLS' 
	print, 'Location set to ', location 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_Location_Other, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Location') 
   	WIDGET_CONTROL,id, Sensitive=1, Get_value = test 
	location = test(0) 
	print, 'Location set to Other: ', location 
end 
 
PRO TXT_Set_Location, Event 
@axis_com
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Location') 
   	WIDGET_CONTROL,id, Sensitive=1, Get_value = test 
	location = test(0) 
	print, 'Location set to ', location 
end 
 
; ***********************  SIZE of AXIS Widget ******************* 
;----------------------------------------------------------------- 
pro BUT_Size_075, Event 
@axis_com
	gr_scale = 0.75 
	print, 'Size set to (1: Main = 360 pixels)', gr_scale 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
pro BUT_Size_100, Event 
@axis_com
	gr_scale = 1.0 
	print, 'Size set to (1: Main = 360 pixels)', gr_scale 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
pro BUT_Size_125, Event 
@axis_com
	gr_scale = 1.25 
	print, 'Size set to (1: Main = 360 pixels)', gr_scale 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
pro BUT_Size_150, Event 
@axis_com
	gr_scale = 1.50 
	print, 'Size set to (1: Main = 360 pixels)', gr_scale 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
PRO Zero_buts, Event 
; ----------------------- last changed:  28-Dec-98 
@axis_com
; ----------- Zero Exclusive Buttons - NB must turn off all first ! 
; ---- operating system 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_WIN') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_X') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_OpSys_Other') 
   WIDGET_CONTROL,id, Set_Button = 0 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Op_Sys') 
   	WIDGET_CONTROL,id, Sensitive=0 
; ---- print device 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_PS') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_PCL') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Print_Other') 
   WIDGET_CONTROL,id, Set_Button = 0 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Print_device') 
   	WIDGET_CONTROL,id, Sensitive=0 
; ------- location 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Mac') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_ALS') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_NSLS') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Location_Other') 
   WIDGET_CONTROL,id, Set_Button = 0 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Set_Location') 
   	WIDGET_CONTROL,id, Sensitive=0 
; ------ size of AXIS 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Size_075') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Size_100') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Size_125') 
   WIDGET_CONTROL,id, Set_Button = 0 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Size_150') 
   WIDGET_CONTROL,id, Set_Button = 0 
 
END 
 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro Load_def_Win, Event 
; ------------------------ last changed:  24-May-99 
@axis_com
;--------- predefine defaults to those for WIN at McMaster ----------- 
; BUT DOES NOT CHANGE the current values of paramaters 
 
   LPath = '' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Source_Path') 
   WIDGET_CONTROL,id, Set_Value ='c:\axis\' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Ini_File') 
   WIDGET_CONTROL,id, Set_Value = 'c:\axis\axis.ini' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Print_command') 
   WIDGET_CONTROL,id, Set_Value = 'copy idl.ps lpt1:' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Font') 
   WIDGET_CONTROL,id, Set_Value = 'Arial*14' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Data_Path') 
   WIDGET_CONTROL,id, Set_Value = 'c:\data' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Color_Table') 
   WIDGET_CONTROL,id, Set_Value = string(0) 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Help_cmd') 
   WIDGET_CONTROL,id, Set_Value = 'c:\acrobat3\exchange\acroex32 axis.pdf' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Web_cmd') 
   WIDGET_CONTROL,id, Set_value = 'c:\progra~1\netscape\communicator\program\netscape' 
 
   Zero_buts, Event  ; Turn off all exclusive buttons 
; ----------- Set Exclusive Buttons 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_WIN') 
   WIDGET_CONTROL,id, Set_Button = 1 
; ---- print device 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_PS') 
   WIDGET_CONTROL,id, Set_Button = 1 
; ------ size of AXIS 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Size_100') 
   WIDGET_CONTROL,id, Set_Button = 1 
; ------- location 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Mac') 
   WIDGET_CONTROL,id, Set_Button = 1 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro Load_Def_X, Event 
; ------------------- last changed: 29-Dec-98 
; set defaults for X-windows UNIX op sys at ALS 
; BUT DOES NOT CHANGE the current values of paramaters 
 
@axis_com
 
   LPath = '' 
;   CodePath = '/home/bl7data/axisdir/' 
; 	Ini_file = '/home/bl7data/axisdir/axis_als.ini' 
;   gr_dev = 'X' 
;   Print_Dev = 'PS' 
;   DefPath='/home/bl7data/stxmdata/after6197/text' 
;   gr_scale=1.5 
;   ColTbl = 0 
;   location = 'ALS'				; location - to allow switching location specific code 
;   Print_file = 'idl.ps'	; default print file name (postscript) 
;   Pr_command = 'lpr -S XRAYS-1 -P 6-BL7LJ4 idl.ps'   ; print command at BL7-Dow 
;   BufLblFont = '6x10'   	; default font 
;	Help_cmd = 'acroRd32 /home/bl7data/axisdir/axis.pdf' 
 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Source_Path') 
   WIDGET_CONTROL,id, Set_Value = '/home/bl7data/axisdir/' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Ini_File') 
   WIDGET_CONTROL,id, Set_Value = '/home/bl7data/axisdir/axis_als.ini' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Print_command') 
   WIDGET_CONTROL,id, Set_Value = 'lpr -S XRAYS-1 -P 6-BL7LJ4 idl.ps' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Font') 
   WIDGET_CONTROL,id, Set_Value = '6x10' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Data_Path') 
   WIDGET_CONTROL,id, Set_Value = '/home/bl7data/stxmdata/after6197/text' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Color_Table') 
   WIDGET_CONTROL,id, Set_Value = string(0) 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Help_cmd') 
   WIDGET_CONTROL,id, Set_Value = 'acroRd32 /home/bl7data/axisdir/axis.pdf' 
   id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Web_cmd') 
   WIDGET_CONTROL,id, Set_value = 'netscape' 
 
   Zero_buts, Event  ; Turn off all exclusive buttons 
; ----------- Set Exclusive Buttons 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_X') 
   WIDGET_CONTROL,id, Set_Button = 1 
; ---- print device 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_PS') 
   WIDGET_CONTROL,id, Set_Button = 1 
; ------ size of AXIS 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_Size_150') 
   WIDGET_CONTROL,id, Set_Button = 1 
; ------- location 
   id = widget_info(Event.top, FIND_BY_UNAME = 'BUT_ALS') 
   WIDGET_CONTROL,id, Set_Button = 1 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_INI_Browse, Event 
@axis_com
; get current value of AXIS initialization file 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Ini_File') 
	WIDGET_CONTROL, id, Get_Value = test 
	ini_file = string(test(0)) 
;	print, 'Current ini file is ', ini_file 
; check if it exists 
	test = FINDFILE(ini_file,count=cnt) 
;	print, cnt,' files found' & print, test 
	if cnt EQ 1 then ini_file = string(test(0)) else ini_file = '' 
; pop-up file selector, with ini_file if it exists 
	ini_file = dialog_pickfile(file=ini_file, filter='*.ini',title='AXIS defaults file') 
; update text widget with ini file name unless no value 
 	IF ini_file NE '' then WIDGET_CONTROL, id, Set_Value = ini_file 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_Source_Browse, Event 
@axis_com
; get current value of AXIS Source_path (loction of AXIS *.pro etc) 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Source_Path') 
	WIDGET_CONTROL, id, Get_Value = test 
	source_path = string(test(0)) 
;	print, 'Current source_path is ', source_path 
; pop-up file selector, with source_path if it exists 
	source_path = dialog_pickfile(file='*.pro', path = source_path, $ 
		filter='*.pro',title='AXIS source path (select any file)', Get_Path=stest) 
	source_path = string(stest(0)) 
; update text widget with source_path unless no value 
 	IF source_path NE '' then WIDGET_CONTROL, id, Set_Value = source_path 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_Data_Browse, Event 
@axis_com
; get current value of data_path 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Data_Path') 
	WIDGET_CONTROL, id, Get_Value = test 
	data_path = string(test(0)) 
;	print, 'Current data_path is ', data_path 
; pop-up file selector, with data_path if it exists 
	data_path = dialog_pickfile(file='*.*',path = data_path, $ 
	     title='Initial Data path (select any file)', Get_Path=stest) 
	data_path = string(stest(0)) 
; update text widget with data_path unless no value 
 	IF data_path NE '' then WIDGET_CONTROL, id, Set_Value = data_path 
 
end 
 
; **************************************************************** 
;----------------------------------------------------------------- 
 
pro BUT_Print_Browse, Event 
@axis_com
 
; -------- last changed: 24-may-99 
; replace print file name with printer command 
   	id = widget_info(Event.top, FIND_BY_UNAME = 'TXT_Print_command') 
	WIDGET_CONTROL, id, Get_Value = test 
	Pr_Command = string(test(0)) 
;	print, 'Current print/spool file is ', Pr_command 
; check if it exists 
;	test = FINDFILE(print_file,count=cnt) 
;	print, cnt,' files found' & print, test 
;	if cnt EQ 1 then print_file = string(test(0)) else print_file = '' 
; pop-up file selector, with print_file if it exists 
;	print_file = dialog_pickfile(file=print_file, filter='*.ps', title='Print/Spool file') 
; update text widget with print file name unless no value 
 	IF print_file NE '' then WIDGET_CONTROL, id, Set_Value = print_file 
end 
; 
; Empty stub procedure used for autoloading. 
; 
pro axis_options_eventcb 
end 
