; Copyright (c) 1998-2001 A.P. Hitchcock  All rights reserved

; ************************** AXIS2000.PRO ***********************************
; start-up file for AXIS2000
; IDL Program Suite for Analysis of X-ray microscopy Image and Spectral data
; @Hitchcock Enterprises unlimited
; ******************************************* AXIS 2000 (2.1j) **************
;
; AXIS2000.PRO is the front end of the AXIS program suite
;   used to determine the program directory and initialization file.
;
;
;+
;NAME:
;   AXIS2000
;
;LAST CHANGED: -----------------------------------  6-10-03 (tt)
;
;PURPOSE:
;   This procedure compiles all files used by the AXIS widget.
;
;CATEGORY:
;   AXIS: utility
;
;CALLING SEQUENCE:  AXIS2000, directory=directory, start_file='*.ini', , help=help, /dialog
;
;INPUTS: none
;
;KEYWORDS:
;   directory code directory
;   start_file    name of *.ini file
;   dialog       use a pick file dialog to select code directory and start file
;   spin   activate spinning logo
;   help   print a help text
;
;OUTPUTS: starts execution of AXIS
;
;COMMON BLOCKS: axis_com
;
; PROCEDURE
;
;
;MODIFICATION HISTORY:
; (08-dec-00 cgz) first written
; (23-jan-01 cgz) Added initial specification of ini_file if start_file is not specified
; (23-jan-01 cgz) Added /help option to give help message
; (31-jan-01 aph) get so that will auto-run on PC from start_file call (redo of 12-jan-01 changes)
; (22-aug-01 aph) add spin keyword
; (28-jul-02 aph) set directory to 'CodePath' (from axis.ini file), if not defined in call
; (6-Oct-03 tt) no startup options
;-
;

PRO aXis2000

; Options:
;   directory :   actual directory of Axis source code
;      :   NOT implemented - if set equal 'dialog', then dialog_pickfile will be invoked to get directory
;   start_file    :  actual filename of parameter file *.ini
;      :   NOT implemented - if set equal to 'dialog', then dialog_pickfile will be invoked to get *.ini file
;   dialog    :  use dialog_pickfile to get both directory of Axis source code and *.ini file
;      :   if /dialog option is invoked, the values of directory and start_file will be used as initial values during dialog_pickfile

@axis_com


;IF (n_elements(directory) EQ 0) THEN begin
;   print, ' setting default directory to ', CodePath
;   directory = CodePath
;    directory = 'c:\axis2000\'
;    cd, directory
;ENDIF
;IF (n_elements(start_file) EQ 0) THEN begin
;    start_file = 'axis.ini'
;    ini_file = 'axis.ini'
;ENDIF
;IF keyword_set(dialog) THEN do_dialog = 1 ELSE do_dialog = 0

ini_file = 'axis.ini'   ; APH's solution to bug of dec-00
;codepath = 'c:\axis2003\'
;cd,codepath    ; change directory to codepath
;location = codepath

axis_c, start_file = ini_file


return
END