; Copyright (c) 1998-2000 A.P. Hitchcock  All rights reserved 
;+ 
;NAME: 
;	 AX_WRITE_XAS 
; 
;LAST CHANGED: ----------------------------------- 27-feb-00 
; 
;PURPOSE: 
;	This procedure writes a 1d data structure (spectrum) as a 
; nsls X1A *.xas format, annotated ascii file. 
; The user is prompted for header information. 
; 
;CATEGORY: 
;	AXIS: utility 
; 
;CALLING SEQUENCE: 
;	 AX_WRITE_XAS, tmp, file = file, nof = nof 
; 
;CALLED FROM AXIS: 
;	->WRite->XAS 
; 
;INPUTS: 
;	TMP - AXIS 1d-structure 
; 
;KEYWORDS: 
;	FILE filename. If not supplied the user is prompted for the filename. 
;	nof = no filter (default filter is *.xas) 
; 
;OUTPUTS: 
;	An XAS-format file is written. 
; 
;COMMON BLOCKS: 
;	@AXIS_COM	standard set of common blocks 
; 
;MODIFICATION HISTORY: 
; (31-jsn-00 aph) first written to allow use of axis data as Io for Zimba stack_analyze. 
; (27-feb-00 aph) AXIS standard documentation; groupID for get_text 
;- 
PRO ax_write_xas, tmp, file = file, nof = nof 
 
@axis_com
on_error,2 
 
if not keyword_set(file) then begin 
	fltr='*.xas' 
	if keyword_set(nof) then fltr='*' 
	file = pickfile2(/write, FILTER=fltr, /LPATH, DefPath=WritePath) ;, get_path=WritePath) 
endif 
 
; -- write ascii format data file --- 
if strlen(file) GT 0 THEN BEGIN  ; bail-out if no filename 
 
	text = Get_text(PROMPT = 'Label', val = tmp.dl, group = axis_ID) 
	tmp.dl = text  		; update and save buffer label 
	if widget_info(/active) EQ 1 then begin 
		Label(CurBuf) = tmp.dl 
		HANDLE_value, Data(CurBuf), tmp, /set 
		BLbl_upd 
	endif 
 
	text = Get_text(PROMPT = 'Set header(Y/N)?', val = ' N', group = axis_ID) 
	if strmid(text(0), 0,1)  EQ 'Y' then begin 
		ax_header = {header,$ 
             formula: '',common_name: '',edge: '',$ 
             acquisition_mode: '',source_purity: '',comments: '',$ 
             delta_ev: '',min_ev: '',max_ev: '',yaxis: '', $ 
             contact_person: '',write_date: '',journal: '',$ 
             authors: '',title: '',volume: '',$ 
             issue_number: '',year: '',pages: '',$ 
             booktitle: '',editors: '',publisher: '',$ 
             address: ''} 
; ------ allow user to define all values for header 
		ax_header.formula = get_text(prompt='formula', val=tmp.dl, group = axis_ID) 
		ax_header.common_name = get_text(prompt='common_name', val='', group = axis_ID) 
		ax_header.edge = get_text(prompt='edge', val='', group = axis_ID) 
		ax_header.acquisition_mode = get_text(prompt='acquisition_mode', val='', group = axis_ID) 
		ax_header.source_purity = get_text(prompt='source_purity', val='', group = axis_ID) 
		ax_header.comments = get_text(prompt='comments', val=tmp.dl, group = axis_ID) 
		ax_header.delta_ev = get_text(prompt='delta_ev', val='', group = axis_ID) 
		ax_header.min_ev = min(tmp.x, max = max_ev) 
		ax_header.max_ev = max_ev 
		ax_header.yaxis = get_text(prompt='yaxis', val='', group = axis_ID) 
		ax_header.contact_person = get_text(prompt='contact_person', val='', group = axis_ID) 
		ax_header.write_date = '' 
		ax_header.journal = get_text(prompt='journal', val='', group = axis_ID) 
		ax_header.authors = get_text(prompt='authors', val='', group = axis_ID) 
		ax_header.title = get_text(prompt='title', val='', group = axis_ID) 
		ax_header.volume = get_text(prompt='volume', val='', group = axis_ID) 
  		ax_header.issue_number = get_text(prompt='issue_number', val='', group = axis_ID) 
		ax_header.year = get_text(prompt='year', val='', group = axis_ID) 
		ax_header.pages = get_text(prompt='pages', val='', group = axis_ID) 
		ax_header.booktitle = get_text(prompt='booktitle', val='', group = axis_ID) 
		ax_header.editors = get_text(prompt='editors', val='', group = axis_ID) 
		ax_header.publisher = get_text(prompt='publisher', val='', group = axis_ID) 
		ax_header.address = get_text(prompt='address', val='', group = axis_ID) 
		write_xas, file, tmp.x, tmp.d, ax_header 
	endif else 	write_xas, file, tmp.x, tmp.d, formula = tmp.dl 
 
	print, 'Spectrum written to XAS file: ', file 
 
endif 
END 
