; Copyright (c) 1998-2004 A.P. Hitchcock  All rights reserved
;+
;NAME:
;  GenExptrap
;
;LAST CHANGED: ----------------------------------- 21-Jul-06
;
; PURPOSE:
;	extrapolates a spectrum from known points to unkown points
;
; CATEGORY:
;	spectra Processing; stand alone operation
;
; CALLING SEQUENCE:
;	SFConvert, En, Data
;
; INPUTS:
; 	Data	2d array of energy and spectral data from OD of sample
;	En		1d Array of new energy scale
;
; KEYWORDS: none
;
; OUTPUTS: 	none
;
; COMMON BLOCKS: none
;
;
; RESTRICTIONS: none
;
; MODIFICATION HISTORY:
; (21-Jul-06 jso) first version

function GenExtrap, En=En, Data=Data

	ans = fltarr(N_elements(En))
	for i = 0, N_elements(En)-1 do begin
		Ans[i]=averageval(arr=data,Val=En[i])
	EndFor

return, ans
End