; Copyright (c) 1998-2002 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	AX_ONE_PT
;
;LAST CHANGED: ----------------------------------- 9-sep-02
;
;PURPOSE:
;	This procedure allows the user to delete or add a single point in a spectrum
; or to change a point in an image

;CATEGORY:
;	AXIS: spectrum analysis (captive to aXis2000)
;
;CALLING SEQUENCE:
;	AX_ONE_PT
;
;CALLED FROM AXIS:
;	Spectra->Modify one point
;	Images->Modify one point

;INPUTS: none
;
;KEYWORDS: none
;
;OUTPUTS:
;	modified spectrum or image is placed in buffer 0.
;
;COMMON BLOCKS:
;	@AXIS_COM	standard set of common blocks
;
;MODIFICATION HISTORY:
; (09-sep02 aph) first version; adapted from zx_xycal.pro
;-

PRO ax_one_pt
@axis_com
on_error,2

HANDLE_VALUE, Data(CurBuf), tmp
IF n_tags(tmp) EQ 0 THEN RETURN
SetGraf, 'MainImg'
text = 'Modify One Point'
WIDGET_CONTROL, Uprompt,  Bad_ID=badID, SET_VALUE=text
text = '     [left click] = add'
WIDGET_CONTROL, Uprompt,  Bad_ID=badID, SET_VALUE=text, /append
text = '     [right click] = delete'
WIDGET_CONTROL, Uprompt,  Bad_ID=badID, SET_VALUE=text, /append
cursor, x1, y1, /data, /down
 if tmp.t EQ '1d' then begin         ;  spectra
; ------------------- handle points BELOW data range
	if x1(0) le min(tmp.x) then begin
		if !mouse.button EQ 1 then begin        ; left button was pressed means ADD
; add point at (x,y) of cursor
			tx = [x1(0),tmp.x]
			td = [y1(0),tmp.d]
			tmp.dl = tmp.dl + '+1pt'
		endif else begin
; delete first point
			tx = tmp.x(1:n_elements(tmp.x)-1)
			td = tmp.d(1:n_elements(tmp.d)-1)
			tmp.dl = tmp.dl + '-1pt'
		endelse
		tmp = create_struct('t','1d','x',tx,'d',td,'dn',td,'xl',tmp.xl,'dl',tmp.dl)
		goto,skip
	endif
; --------------------------- handle points ABOVE data range
	if x1(0) ge max(tmp.x) then begin
		if !mouse.button EQ 1 then begin        ; left button was pressed means ADD
; add point at (x,y) of cursor
			tx = [tmp.x,x1(0)]
			td = [tmp.d,y1(0)]
			tmp.dl = tmp.dl + '+1pt'
		endif else begin
; delete last point
			tx = tmp.x(0:n_elements(tmp.x)-2)
			td = tmp.d(0:n_elements(tmp.d)-2)
			tmp.dl = tmp.dl + '-1pt'
		endelse
		tmp = create_struct('t','1d','x',tx,'d',td,'dn',td,'xl',tmp.xl,'dl',tmp.dl)
		goto,skip
	endif
; ------------ process when selected point is inside data range
	t = where(tmp.x LE x1(0), count)
	if count GE 0 then ind = max(t) else ind = 0
;	print, '(',x1(0),',',y1(0),')  closest lower x ',ind, tmp.x(ind)
	if !mouse.button EQ 1 then begin       ; left button was pressed means ADD
; add point at (x,y) of cursor
		tx = fltarr(n_elements(tmp.x)+1)
		td = fltarr(n_elements(tmp.d)+1)
		tx[0:ind] = tmp.x[0:ind]
		tx[ind+1] = x1(0)
		tx[ind+2:n_elements(tmp.x)] = tmp.x[ind+1:n_elements(tmp.x)-1]
		td[0:ind] = tmp.d[0:ind]
		td[ind+1] = y1(0)
		td[ind+2:n_elements(tmp.d)] = tmp.d[ind+1:n_elements(tmp.d)-1]
		tmp.dl = tmp.dl + '+1pt'
		tmp = create_struct('t','1d','x',tx,'d',td,'dn',td,'xl',tmp.xl,'dl',tmp.dl)
	endif else begin
; delete closest point
; determine whether ind or ind+1 is the closer point
		if (tmp.x(ind+1) - x1(0) LT x1(0) - tmp.x(ind)) then ind = ind+1
		tx = tmp.x & ty = tmp.d
		tmp.x = fltarr(n_elements(tx)-1)
		tmp.d = fltarr(n_elements(ty)-1)
		tmp.x[0:ind-1] = tx[0:ind-1]
		tmp.x[ind:n_elements(tx)-2] = tx[ind+1:n_elements(tx)-1]
		tmp.d[0:ind-1] = ty[0:ind-1]
		tmp.d[ind:n_elements(ty)-2] = ty[ind+1:n_elements(ty)-1]
		tmp.dn = tmp.d
		tmp.dl = tmp.dl + '-1pt'
	endelse

; ------------ regenerate data structure ---------------------------
skip:
	CurBuf = 0
	HANDLE_VALUE, Data(CurBuf), tmp, /set
	Label(CurBuf) = tmp.dl
	PlotBuf,CurBuf, /same_scale
 endif
 if tmp.t EQ '2d' then begin			; IMAGES
 	CurInd = DIndex(x1(0),y1(0),tmp)
	CurX1 = CurInd(0) & CurY1 = CurInd(1)
	avg = moment(tmp.d,/nan)
	zn = get_num(prompt='new value',val=avg, group = axis_id)
  	tmp.d(CurX1, CurY1) = zn
  	tmp.dl = tmp.dl + ' m1'
	CurBuf = 0
	HANDLE_VALUE, Data(CurBuf), tmp, /set
	Label(CurBuf) = tmp.dl
	PlotBuf,CurBuf
 endif
END
