; $Id: join_string.pro,v 1.1 1996/12/30 02:48:43 loo Exp $ 
; 
;+ 
; NAME: 
;       JOIN_STRING 
; 
; PURPOSE: 
;       This function joins the elements of a string array into a 
;       scalar string array, with the original elements separated by 
;       a user specified delimiter. 
; 
; CATEGORY: 
;       String processing. 
; 
; CALLING SEQUENCE: 
;       Result = JOIN_STRING(Input) 
; 
; INPUTS: 
;       Input:     The string array to be joined. 
; 
; KEYWORD PARAMETERS: 
;       DELIMITER: A string containing the delimiter between words. 
;                  The default delimiter is a single space. 
; 
;       HEADER:    A string containing characters to precede the first 
;                  element. The default is no header. 
; 
;       FOOTER:    A string containing characters to follow the last  
;                  element. The default is no footer. 
; 
; OUTPUTS: 
;       Returns the scalar string variable containing the joined result. 
; 
; EXAMPLE: 
;       If the input string is: 
;         input = ['Hello', 'world'] 
; 
;       then the command sequence: 
;         result = JOIN_STRING(input, DELIMITER=', ') 
; 
;       produces the result: 
;         IDL> print, result 
;         Hello, world 
; 
;       Note that the delimiter in this case includes a space. 
; 
; WRITTEN BY: 
;       Billy W. Loo, Jr. 
;       Bioengineering Graduate Group, UCSF / UCB 
;       School of Medicine, UCD 
;       Lawrence Berkeley National Lab 
;       December, 1996 
;- 
; 
; MODIFICATION HISTORY: 
; 
; $Log: join_string.pro,v $ 
; Revision 1.1  1996/12/30 02:48:43  loo 
; Initial revision 
; 
 
FUNCTION JOIN_STRING, input, DELIMITER=delimiter, HEADER=header, FOOTER=footer 
  ;Return to main level on error. 
  ;ON_ERROR, 1 
 
  ;Check that input is of type STRING. 
  sz = SIZE(input) 
  IF (sz(sz(0)+1) NE 7) THEN MESSAGE, 'Input must be string variable.' 
 
  ;Check if delimiter is specified and is of type string. 
  IF (N_ELEMENTS(DELIMITER) EQ 0) THEN BEGIN 
    delimiter = ' ' 
  ENDIF $ 
 
  ELSE BEGIN 
    sz = SIZE(delimiter) 
    IF (sz(sz(0)+1) NE 7) OR (sz(sz(0)+2) NE 1) THEN $ 
      MESSAGE, 'Delimiter must be scalar string.' 
  ENDELSE 
 
  ;Check if header is specified and is of type string. 
  IF (N_ELEMENTS(HEADER) EQ 0) THEN BEGIN 
    header = '' 
  ENDIF $ 
 
  ELSE BEGIN 
    sz = SIZE(header) 
    IF (sz(sz(0)+1) NE 7) OR (sz(sz(0)+2) NE 1) THEN $ 
      MESSAGE, 'Header must be scalar string.' 
  ENDELSE 
 
  ;Check if footer is specified and is of type string. 
  IF (N_ELEMENTS(FOOTER) EQ 0) THEN BEGIN 
    footer = '' 
  ENDIF $ 
 
  ELSE BEGIN 
    sz = SIZE(footer) 
    IF (sz(sz(0)+1) NE 7) OR (sz(sz(0)+2) NE 1) THEN $ 
      MESSAGE, 'Footer must be scalar string.' 
  ENDELSE 
 
  ;Create temporary array to hold original plus delimeter. 
  num_in = N_ELEMENTS(input) 
 
  temp = input 
 
  IF (num_in GT 1) THEN temp(0:num_in-2) = temp(0:num_in-2) + delimiter 
 
  ;Concatenate elements into result. 
  result = '' 
  FOR i = 0, num_in-1 DO BEGIN 
    result = TEMPORARY(result) + temp(i) 
  ENDFOR 
 
  result = header + TEMPORARY(result) + footer 
 
  RETURN, result 
END ;join_string 
