; Copyright (c) 1998-2016 A.P. Hitchcock  All rights reserved
;+
;NAME:
;		AX_DTS
;
;LAST CHANGED: ----------------------------------- 	25 Apr 2016
;
; PURPOSE:
;	This function checks for doubles (reals, integers (signed & unsigned)
; and converts to the equivalent singles if found. works with everythnig except structures
;
; CATEGORY:
;	Utility
;
; CALLING SEQUENCE:
;	Result = AX_DTF(tmp)
;
; INPUTS:
;  TMP - variable to convert
;
; KEYWORDS: none
;
; OUTPUTS: The same or a converted version of TMP
;
; COMMON BLOCKS: none
;
; MODIFICATION HISTORY:
; (25-Apr-16 aph) first developed
;-

FUNCTION ax_dts, tmp

; ---------check if variable is a double; if so change to a single
check = size(tmp, /type)
CASE CHECK OF
	 5: tmp = float(tmp)
	14: tmp = long(tmp)
	15: tmp = ulong(tmp)
ENDCASE

return,tmp

end
