; Copyright (c) 1998-2017 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	BUFFER
;
;LAST CHANGED: ----------------------------------- 10 Jul 2017 (bw 26-may-2017)
;
;PURPOSE:
;	This function selectsan AXIS buffer for use in various processing steps.
;
;CATEGORY:
;	AXIS: utility
;
;CALLING SEQUENCE:
;	Result = BUFFER(GROUP=Group, Prompt=Prompt)
;
;CALLED FROM AXIS:
;	many places
;
;ROUTINES
;	BUFFER_Event, Event - processes button pushes on Buffer widget
;
;INPUTS:
;	INPUT - POSITIONAL INPUTS only (not keywords)
;	All input parameters are passed as keywords.
;
;KEYWORDS:
;	 GROUP = parent calling buffer (AXIS_ID from axis) - to allow modal
;	 Prompt = prompt to inform user purpose of buffer selection
;
;OUTPUTS:
;	The number of the selected buffer is returned.
;   If the user pushes cancel, the returned value is -1.
;
;COMMON BLOCKS:
;	B, Buf - number of selected buffer (to transfer between function & event processor)
;
;SIDE EFFECTS:
;	A widget is created/destroyed.
;
;MODIFICATION HISTORY:
; (xx-yyy-07 aph) first written
; (20-dec-98 aph) correct pattern for IDL5.2; add 'Cancel'
; (11-jun-99 aph) extend prompt information
; (23-feb-00 aph) AXIS standard documentation
; (15-Jan-13 aph)  force this to display in middle of the call program
; (26-May-17 bw)  add small wait before realizing widget in order to fix linux bug
; (10 Jul-17 aph) checked works with Wndows
;-

PRO BUFFER_Event, Event

COMMON B, Buf
WIDGET_CONTROL,Event.Id,GET_UVALUE=Ev

CASE Ev OF
  'BGROUP3': BEGIN
    CASE Event.Value OF
      0: Buf = 1
      1: Buf = 2
      2: Buf = 3
      3: Buf = 4
      4: Buf = 5
      5: Buf = 6
      6: Buf = 7
      7: Buf = 8
      8: Buf = 9
      9: Buf = 0
      10: Buf = -1
    ELSE: Message,'Unknown button pressed'
    ENDCASE
    END
ENDCASE
WIDGET_CONTROL, Event.Top, /DESTROY
END

Function Buffer, GROUP=Group, Prompt=Prompt

COMMON B, Buf

IF n_elements(Group) EQ 0 THEN begin
    GROUP=0
    modal_val = 0
ENDIF ELSE modal_val = 1

junk   = { CW_PDMENU_S, flags:0, name:'' }

BUFFER = WIDGET_BASE(GROUP_LEADER=Group, $
	MODAL = 1, $ ; modal_val, $
    MAP=1, $
 ;  TITLE='Select a buffer', $
    UVALUE='BUFFER') ;, $

Btns440 = [ $
    '1', $
    '2', $
    '3', $
    '4', $
    '5', $
    '6', $
    '7', $
    '8', $
    '9', $
    '0', $
    'Cancel']
if not keyword_set(prompt) then prompt = 'Choose Buffer'
BGROUP3 = CW_BGROUP( BUFFER, Btns440, $
      ROW=4, $
      LABEL_TOP=Prompt, $
      UVALUE='BGROUP3')

WAIT, 0.1
WIDGET_CONTROL, BUFFER, /REALIZE

XMANAGER, 'BUFFER', BUFFER
return, buf

END
