; Copyright (c) 1998-2018 A.P. Hitchcock  All rights reserved
;+
;NAME:
;	STACK_PROCESS_COM
;
;LAST CHANGED: ----------------------------------- 29-Nov-18
;
; PURPOSE:
;	This FILE contains the COMMON block, stack_process_common
;
; CATEGORY:
;	AXIS: Stack_analyze common block
;
; CALLING SEQUENCE:
;	@stack_process_com (to include in the stack_process (axis2000 version of stack_analyze) routines)
;
; INPUTS: none
;
; KEYWORDS: none
;
; OUTPUTS: none
;
; DETAILS: - variables in the common block:
;   plot_cols, plot_rows: size of plot region in pixels
;   char_ypix: height of a character in pixels
;   charsize: scaling to have characters come out at char_ypix height
;   textregion_ypix: height of text plus scalebar region below image
;   textregion_nlines: number of lines to text plus scalebar region
;   r,g,b: color vectors for 8 bit display
;   i_color_index, i0_color_index: color indices for I and I0 respectively
;   top_color_index: full white
;	disp_xmin, disp_xmax, disp_ymin, disp_ymax
;
; MODOFICATIONS
; (16-apr-98 aph) - added filepath, filesave to common !!
;  filename_header = filepath + sep + filesave,
;                  where sep is system specific separator
;                  and parameters related to Io readin
; (30-jun-98 aph) - added OD_flag, rescale_flag,stop_flag
; ( 6-jul-98 aph) - moviestate, framenum, framerate:  for movies
; ( 6-jul-98 aph) - spectrum_x_scale, spectrum_y_scale: to allow cursor selection of image
; ( 6-jul-98 aph) - filename_ev_msec_list: to update E-scales
; ( 7-jul-98 aph) - sub_flag, ref_spectrum: to allow subtraction of ref. spectrum
; (14-may-99 aph) - tey_flag to prevent logarithm
; (25-jun-99 aph) - remove xx_color_index (in axis_com, part of ax_color)
; (29-jun-99 aph) - put color_index items back; axis_colr_common kept separate
; (31-dec-99 aph) - standard documentation
; (09-apr-00 aph) - add stack_analyze_par.sub_image, stack_analyze_par.sub_stack
; (08-may-00 aph) - add xpix_shift, ypix_shift - 2d arrays with mon/max shifts - separate common
; (22-feb-04 aph) - add disp_xmin, disp_xmax, disp_ymin, disp_ymax, ixl, ixh, iyl, iyh
; (26-mar-04 aph) - add disp_emin, disp_emax
; (02-may-04 aph) - add sa_debug
; (18-feb-06 aph) - add peak_img, bgnd_1, etc for mapping
; (23-apr-06 aph) - multi-region plotting - n_roi, i_roi becomes 2d
; (18-mar-07 aph) - add limits (for fitting stacks)
; (17-Sep-08 aph) - change name to stack_process_com to differentiate
;                    from similar common block in jacobsen's stack_analyze
; (29-Nov-14 aph) - removed filepath from the common block (filepath and path are FUNCTIONS in IDL)
;                   replaced with DefPath (which is in aXis_com
; (25-Apr-16 aph) - change name of stack_analyze_par to stack_process_par
; (18-Mar-18 aph) - add 'sp_fileshort'   - stack name (without folder or *.ncb)
;-

COMMON stack_process_common,$
  stack_process_par,$
  roi,roi_filename, n_roi, i_roi,i0_roi,i_signal,i0_signal, $
  filename_list,ev,filename_ev_list,displayed_file_index, sp_fileshort, $
  spectrum,spectrum_title,filesave,filename_header, $
  char_ypix,charsize,textregion_nlines,textregion_ypix,$
  r,g,b,i_color_index,i0_color_index,white_color_index,top_color_index,$
  plot_rows,plot_cols,img_zoom,disp_min,disp_max,disp_gamma,$
  bar_pixels,bar_string,bar, $
  i0_read,i0_data, OD_flag, rescale_flag, stop_flag, tey_flag, $
  moviestate, framenum, framerate, $
  spectrum_x_scale, spectrum_y_scale, $
  filename_ev_msec_list, $
  disp_xmin, disp_xmax, disp_ymin, disp_ymax,disp_zmin, disp_zmax, disp_emin, disp_emax, $
  ixl, ixh, iyl, iyh, $
  sub_flag, ref_spectrum, sa_debug, $
  peak_img, bgnd_1, B1_wt, bgnd_2, B2_wt, limits
